/*
 * Decompiled with CFR 0.152.
 */
package com.codepine.api.testrail.model;

import com.codepine.api.testrail.TestRail;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializer;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Case {
    private static final String CUSTOM_FIELD_KEY_PREFIX = "custom_";
    private int id;
    @JsonView(value={TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    private String title;
    private int sectionId;
    @JsonView(value={TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    private Integer typeId;
    @JsonView(value={TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    private Integer priorityId;
    @JsonView(value={TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    private Integer milestoneId;
    @JsonView(value={TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    private String refs;
    private int createdBy;
    private Date createdOn;
    private int updatedBy;
    private Date updatedOn;
    @JsonView(value={TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    private String estimate;
    private String estimateForecast;
    private int suiteId;
    @JsonView(value={TestRail.Cases.Add.class, TestRail.Cases.Update.class})
    @JsonIgnore
    private Map<String, Object> customFields;

    @JsonAnyGetter
    @JsonSerialize(keyUsing=CustomFieldSerializer.class)
    public Map<String, Object> getCustomFields() {
        return (Map)MoreObjects.firstNonNull(this.customFields, Collections.emptyMap());
    }

    public Case addCustomField(String key, Object value) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key.replaceFirst(CUSTOM_FIELD_KEY_PREFIX, ""), value);
        return this;
    }

    @JsonAnySetter
    private void addUnknownField(String key, Object value) {
        if (key.startsWith(CUSTOM_FIELD_KEY_PREFIX)) {
            this.addCustomField(key, value);
        }
    }

    public <T> T getCustomField(String key) {
        return (T)this.getCustomFields().get(key);
    }

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSectionId() {
        return this.sectionId;
    }

    public Integer getTypeId() {
        return this.typeId;
    }

    public Integer getPriorityId() {
        return this.priorityId;
    }

    public Integer getMilestoneId() {
        return this.milestoneId;
    }

    public String getRefs() {
        return this.refs;
    }

    public int getCreatedBy() {
        return this.createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public int getUpdatedBy() {
        return this.updatedBy;
    }

    public Date getUpdatedOn() {
        return this.updatedOn;
    }

    public String getEstimate() {
        return this.estimate;
    }

    public String getEstimateForecast() {
        return this.estimateForecast;
    }

    public int getSuiteId() {
        return this.suiteId;
    }

    public Case setId(int id) {
        this.id = id;
        return this;
    }

    public Case setTitle(String title) {
        this.title = title;
        return this;
    }

    public Case setSectionId(int sectionId) {
        this.sectionId = sectionId;
        return this;
    }

    public Case setTypeId(Integer typeId) {
        this.typeId = typeId;
        return this;
    }

    public Case setPriorityId(Integer priorityId) {
        this.priorityId = priorityId;
        return this;
    }

    public Case setMilestoneId(Integer milestoneId) {
        this.milestoneId = milestoneId;
        return this;
    }

    public Case setRefs(String refs) {
        this.refs = refs;
        return this;
    }

    public Case setCreatedBy(int createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public Case setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public Case setUpdatedBy(int updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    public Case setUpdatedOn(Date updatedOn) {
        this.updatedOn = updatedOn;
        return this;
    }

    public Case setEstimate(String estimate) {
        this.estimate = estimate;
        return this;
    }

    public Case setEstimateForecast(String estimateForecast) {
        this.estimateForecast = estimateForecast;
        return this;
    }

    public Case setSuiteId(int suiteId) {
        this.suiteId = suiteId;
        return this;
    }

    public Case setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Case)) {
            return false;
        }
        Case other = (Case)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        if (this.getSectionId() != other.getSectionId()) {
            return false;
        }
        Integer this$typeId = this.getTypeId();
        Integer other$typeId = other.getTypeId();
        if (this$typeId == null ? other$typeId != null : !((Object)this$typeId).equals(other$typeId)) {
            return false;
        }
        Integer this$priorityId = this.getPriorityId();
        Integer other$priorityId = other.getPriorityId();
        if (this$priorityId == null ? other$priorityId != null : !((Object)this$priorityId).equals(other$priorityId)) {
            return false;
        }
        Integer this$milestoneId = this.getMilestoneId();
        Integer other$milestoneId = other.getMilestoneId();
        if (this$milestoneId == null ? other$milestoneId != null : !((Object)this$milestoneId).equals(other$milestoneId)) {
            return false;
        }
        String this$refs = this.getRefs();
        String other$refs = other.getRefs();
        if (this$refs == null ? other$refs != null : !this$refs.equals(other$refs)) {
            return false;
        }
        if (this.getCreatedBy() != other.getCreatedBy()) {
            return false;
        }
        Date this$createdOn = this.getCreatedOn();
        Date other$createdOn = other.getCreatedOn();
        if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
            return false;
        }
        if (this.getUpdatedBy() != other.getUpdatedBy()) {
            return false;
        }
        Date this$updatedOn = this.getUpdatedOn();
        Date other$updatedOn = other.getUpdatedOn();
        if (this$updatedOn == null ? other$updatedOn != null : !((Object)this$updatedOn).equals(other$updatedOn)) {
            return false;
        }
        String this$estimate = this.getEstimate();
        String other$estimate = other.getEstimate();
        if (this$estimate == null ? other$estimate != null : !this$estimate.equals(other$estimate)) {
            return false;
        }
        String this$estimateForecast = this.getEstimateForecast();
        String other$estimateForecast = other.getEstimateForecast();
        if (this$estimateForecast == null ? other$estimateForecast != null : !this$estimateForecast.equals(other$estimateForecast)) {
            return false;
        }
        if (this.getSuiteId() != other.getSuiteId()) {
            return false;
        }
        Map<String, Object> this$customFields = this.getCustomFields();
        Map<String, Object> other$customFields = other.getCustomFields();
        return !(this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Case;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 0 : $title.hashCode());
        result = result * 59 + this.getSectionId();
        Integer $typeId = this.getTypeId();
        result = result * 59 + ($typeId == null ? 0 : ((Object)$typeId).hashCode());
        Integer $priorityId = this.getPriorityId();
        result = result * 59 + ($priorityId == null ? 0 : ((Object)$priorityId).hashCode());
        Integer $milestoneId = this.getMilestoneId();
        result = result * 59 + ($milestoneId == null ? 0 : ((Object)$milestoneId).hashCode());
        String $refs = this.getRefs();
        result = result * 59 + ($refs == null ? 0 : $refs.hashCode());
        result = result * 59 + this.getCreatedBy();
        Date $createdOn = this.getCreatedOn();
        result = result * 59 + ($createdOn == null ? 0 : ((Object)$createdOn).hashCode());
        result = result * 59 + this.getUpdatedBy();
        Date $updatedOn = this.getUpdatedOn();
        result = result * 59 + ($updatedOn == null ? 0 : ((Object)$updatedOn).hashCode());
        String $estimate = this.getEstimate();
        result = result * 59 + ($estimate == null ? 0 : $estimate.hashCode());
        String $estimateForecast = this.getEstimateForecast();
        result = result * 59 + ($estimateForecast == null ? 0 : $estimateForecast.hashCode());
        result = result * 59 + this.getSuiteId();
        Map<String, Object> $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 0 : ((Object)$customFields).hashCode());
        return result;
    }

    public String toString() {
        return "Case(id=" + this.getId() + ", title=" + this.getTitle() + ", sectionId=" + this.getSectionId() + ", typeId=" + this.getTypeId() + ", priorityId=" + this.getPriorityId() + ", milestoneId=" + this.getMilestoneId() + ", refs=" + this.getRefs() + ", createdBy=" + this.getCreatedBy() + ", createdOn=" + this.getCreatedOn() + ", updatedBy=" + this.getUpdatedBy() + ", updatedOn=" + this.getUpdatedOn() + ", estimate=" + this.getEstimate() + ", estimateForecast=" + this.getEstimateForecast() + ", suiteId=" + this.getSuiteId() + ", customFields=" + this.getCustomFields() + ")";
    }

    private static class CustomFieldSerializer
    extends StdKeySerializer {
        private CustomFieldSerializer() {
        }

        public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
            super.serialize((Object)(Case.CUSTOM_FIELD_KEY_PREFIX + o), jsonGenerator, serializerProvider);
        }
    }
}

