/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.cartdiscounts.utils;

import com.commercetools.sync.commons.utils.CustomTypeReferenceReplacementUtils;
import io.sphere.sdk.cartdiscounts.CartDiscount;
import io.sphere.sdk.cartdiscounts.CartDiscountDraft;
import io.sphere.sdk.cartdiscounts.CartDiscountDraftBuilder;
import io.sphere.sdk.cartdiscounts.CartDiscountTarget;
import io.sphere.sdk.cartdiscounts.CartDiscountValue;
import io.sphere.sdk.cartdiscounts.queries.CartDiscountQuery;
import io.sphere.sdk.expansion.ExpansionPath;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.types.CustomFieldsDraft;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class CartDiscountReferenceReplacementUtils {
    @Nonnull
    public static List<CartDiscountDraft> replaceCartDiscountsReferenceIdsWithKeys(@Nonnull List<CartDiscount> cartDiscounts) {
        return cartDiscounts.stream().map(cartDiscount -> {
            CustomFieldsDraft customTypeWithKeysInReference = CustomTypeReferenceReplacementUtils.replaceCustomTypeIdWithKeys(cartDiscount);
            return ((CartDiscountDraftBuilder)((CartDiscountDraftBuilder)((CartDiscountDraftBuilder)((CartDiscountDraftBuilder)((CartDiscountDraftBuilder)((CartDiscountDraftBuilder)((CartDiscountDraftBuilder)CartDiscountDraftBuilder.of((String)cartDiscount.getCartPredicate(), (LocalizedString)cartDiscount.getName(), (boolean)cartDiscount.isRequiringDiscountCode(), (String)cartDiscount.getSortOrder(), (CartDiscountTarget)cartDiscount.getTarget(), (CartDiscountValue)cartDiscount.getValue()).key(cartDiscount.getKey())).description(cartDiscount.getDescription())).active(cartDiscount.isActive())).validFrom(cartDiscount.getValidFrom())).validUntil(cartDiscount.getValidUntil())).stackingMode(cartDiscount.getStackingMode())).custom(customTypeWithKeysInReference)).build();
        }).collect(Collectors.toList());
    }

    public static CartDiscountQuery buildCartDiscountQuery() {
        return (CartDiscountQuery)CartDiscountQuery.of().withExpansionPaths(ExpansionPath.of((String)"custom.type"));
    }

    private CartDiscountReferenceReplacementUtils() {
    }
}

