/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.utils.TriFunction;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.commands.UpdateAction;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class BaseSyncOptionsBuilder<T extends BaseSyncOptionsBuilder<T, S, U, V>, S extends BaseSyncOptions, U, V> {
    protected SphereClient ctpClient;
    protected BiConsumer<String, Throwable> errorCallback;
    protected Consumer<String> warningCallback;
    protected int batchSize = 30;
    protected TriFunction<List<UpdateAction<U>>, V, U, List<UpdateAction<U>>> beforeUpdateCallback;
    protected Function<V, V> beforeCreateCallback;

    public T errorCallback(@Nonnull BiConsumer<String, Throwable> errorCallback) {
        this.errorCallback = errorCallback;
        return this.getThis();
    }

    public T warningCallback(@Nonnull Consumer<String> warningCallback) {
        this.warningCallback = warningCallback;
        return this.getThis();
    }

    public T batchSize(int batchSize) {
        if (batchSize > 0) {
            this.batchSize = batchSize;
        }
        return this.getThis();
    }

    public T beforeUpdateCallback(@Nonnull TriFunction<List<UpdateAction<U>>, V, U, List<UpdateAction<U>>> beforeUpdateCallback) {
        this.beforeUpdateCallback = beforeUpdateCallback;
        return this.getThis();
    }

    public T beforeCreateCallback(@Nonnull Function<V, V> beforeCreateCallback) {
        this.beforeCreateCallback = beforeCreateCallback;
        return this.getThis();
    }

    protected abstract S build();

    protected abstract T getThis();
}

