/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import io.sphere.sdk.models.ResourceIdentifier;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseReferenceResolver<T, S extends BaseSyncOptions> {
    public static final String BLANK_ID_VALUE_ON_RESOURCE_IDENTIFIER = "The value of the 'id' field of the Resource Identifier/Reference is blank (null/empty).";
    protected S options;

    protected BaseReferenceResolver(@Nonnull S options) {
        this.options = options;
    }

    public abstract CompletionStage<T> resolveReferences(@Nonnull T var1);

    @Nonnull
    protected static String getKeyFromResourceIdentifier(@Nonnull ResourceIdentifier resourceIdentifier) throws ReferenceResolutionException {
        String key = resourceIdentifier.getId();
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new ReferenceResolutionException(BLANK_ID_VALUE_ON_RESOURCE_IDENTIFIER);
        }
        return key;
    }
}

