/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.DuplicateKeyException;
import com.commercetools.sync.commons.helpers.AssetActionFactory;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.Asset;
import io.sphere.sdk.models.AssetDraft;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AssetsUpdateActionUtils {
    @Nonnull
    public static <T> List<UpdateAction<T>> buildAssetsUpdateActions(@Nonnull List<Asset> oldAssets, @Nullable List<AssetDraft> newAssetDrafts, @Nonnull AssetActionFactory<T> assetActionFactory) throws BuildUpdateActionException {
        if (newAssetDrafts != null) {
            return AssetsUpdateActionUtils.buildAssetsUpdateActionsWithNewAssetDrafts(oldAssets, newAssetDrafts, assetActionFactory);
        }
        return oldAssets.stream().map(Asset::getKey).map(assetActionFactory::buildRemoveAssetAction).collect(Collectors.toCollection(ArrayList::new));
    }

    @Nonnull
    private static <T> List<UpdateAction<T>> buildAssetsUpdateActionsWithNewAssetDrafts(@Nonnull List<Asset> oldAssets, @Nonnull List<AssetDraft> newAssetDrafts, @Nonnull AssetActionFactory<T> assetActionFactory) throws BuildUpdateActionException {
        Map<String, AssetDraft> newAssetDraftsKeyMap;
        HashSet<String> removedAssetKeys = new HashSet<String>();
        Map<String, Asset> oldAssetsKeyMap = oldAssets.stream().collect(Collectors.toMap(Asset::getKey, asset -> asset));
        try {
            newAssetDraftsKeyMap = newAssetDrafts.stream().collect(Collectors.toMap(AssetDraft::getKey, assetDraft -> assetDraft, (assetDraftA, assetDraftB) -> {
                throw new DuplicateKeyException("Supplied asset drafts have duplicate keys. Asset keys are expected to be unique inside their container (a product variant or a category).");
            }));
        }
        catch (DuplicateKeyException exception) {
            throw new BuildUpdateActionException(exception);
        }
        List<UpdateAction<T>> updateActions = AssetsUpdateActionUtils.buildRemoveAssetOrAssetUpdateActions(oldAssets, removedAssetKeys, newAssetDraftsKeyMap, assetActionFactory);
        AssetsUpdateActionUtils.buildChangeAssetOrderUpdateAction(oldAssets, newAssetDrafts, removedAssetKeys, assetActionFactory).ifPresent(updateActions::add);
        updateActions.addAll(AssetsUpdateActionUtils.buildAddAssetUpdateActions(newAssetDrafts, oldAssetsKeyMap, assetActionFactory));
        return updateActions;
    }

    @Nonnull
    private static <T> List<UpdateAction<T>> buildRemoveAssetOrAssetUpdateActions(@Nonnull List<Asset> oldAssets, @Nonnull Set<String> removedAssetKeys, @Nonnull Map<String, AssetDraft> newAssetDraftsKeyMap, @Nonnull AssetActionFactory<T> assetActionFactory) {
        return oldAssets.stream().map(oldAsset -> {
            String oldAssetKey = oldAsset.getKey();
            AssetDraft matchingNewAssetDraft = (AssetDraft)newAssetDraftsKeyMap.get(oldAssetKey);
            return Optional.ofNullable(matchingNewAssetDraft).map(assetDraft -> assetActionFactory.buildAssetActions((Asset)oldAsset, (AssetDraft)assetDraft)).orElseGet(() -> {
                removedAssetKeys.add(oldAssetKey);
                return Collections.singletonList(assetActionFactory.buildRemoveAssetAction(oldAssetKey));
            });
        }).flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
    }

    @Nonnull
    private static <T> Optional<UpdateAction<T>> buildChangeAssetOrderUpdateAction(@Nonnull List<Asset> oldAssets, @Nonnull List<AssetDraft> newAssetDrafts, @Nonnull Set<String> removedAssetKeys, @Nonnull AssetActionFactory<T> assetActionFactory) {
        Map<String, String> oldAssetKeyToIdMap = oldAssets.stream().collect(Collectors.toMap(Asset::getKey, Asset::getId));
        List newOrder = newAssetDrafts.stream().map(AssetDraft::getKey).map(oldAssetKeyToIdMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        List oldOrder = oldAssets.stream().filter(asset -> !removedAssetKeys.contains(asset.getKey())).map(Asset::getId).collect(Collectors.toList());
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldOrder, newOrder, () -> assetActionFactory.buildChangeAssetOrderAction(newOrder));
    }

    @Nonnull
    private static <T> List<UpdateAction<T>> buildAddAssetUpdateActions(@Nonnull List<AssetDraft> newAssetDrafts, @Nonnull Map<String, Asset> oldAssetsKeyMap, @Nonnull AssetActionFactory<T> assetActionFactory) {
        ArrayList optionalActions = IntStream.range(0, newAssetDrafts.size()).mapToObj(assetDraftIndex -> Optional.ofNullable(newAssetDrafts.get(assetDraftIndex)).filter(assetDraft -> !oldAssetsKeyMap.containsKey(assetDraft.getKey())).map(assetDraft -> assetActionFactory.buildAddAssetAction((AssetDraft)assetDraft, assetDraftIndex))).collect(Collectors.toCollection(ArrayList::new));
        return OptionalUtils.filterEmptyOptionals(optionalActions);
    }

    private AssetsUpdateActionUtils() {
    }
}

