/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.helpers;

import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.ResourceIdentifier;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class InventoryEntryIdentifier {
    private String inventoryEntrySku;
    private String inventoryEntryChannelId;

    private InventoryEntryIdentifier(@Nonnull String inventoryEntrySku, @Nullable String inventoryEntryChannelId) {
        this.inventoryEntrySku = inventoryEntrySku;
        this.inventoryEntryChannelId = inventoryEntryChannelId;
    }

    public static InventoryEntryIdentifier of(@Nonnull InventoryEntryDraft inventoryEntryDraft) {
        ResourceIdentifier supplyChannelIdentifier = inventoryEntryDraft.getSupplyChannel();
        return new InventoryEntryIdentifier(inventoryEntryDraft.getSku(), supplyChannelIdentifier != null ? supplyChannelIdentifier.getId() : null);
    }

    public static InventoryEntryIdentifier of(@Nonnull InventoryEntry inventoryEntry) {
        Reference supplyChannel = inventoryEntry.getSupplyChannel();
        return new InventoryEntryIdentifier(inventoryEntry.getSku(), supplyChannel != null ? supplyChannel.getId() : null);
    }

    public static InventoryEntryIdentifier of(@Nonnull String inventoryEntrySku, @Nullable String inventoryEntryChannelId) {
        return new InventoryEntryIdentifier(inventoryEntrySku, inventoryEntryChannelId);
    }

    public String getInventoryEntryChannelId() {
        return this.inventoryEntryChannelId;
    }

    public String getInventoryEntrySku() {
        return this.inventoryEntrySku;
    }

    public boolean equals(Object obj) {
        if (obj instanceof InventoryEntryIdentifier) {
            InventoryEntryIdentifier that = (InventoryEntryIdentifier)obj;
            return Objects.equals(that.getInventoryEntryChannelId(), this.inventoryEntryChannelId) && Objects.equals(that.getInventoryEntrySku(), this.inventoryEntrySku);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.inventoryEntrySku, this.inventoryEntryChannelId);
    }
}

