/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.sync.commons.utils.AssetReferenceReplacementUtils;
import com.commercetools.sync.commons.utils.CustomTypeReferenceReplacementUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.sphere.sdk.channels.Channel;
import io.sphere.sdk.models.AssetDraft;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.products.Price;
import io.sphere.sdk.products.PriceDraft;
import io.sphere.sdk.products.PriceDraftBuilder;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductVariant;
import io.sphere.sdk.products.ProductVariantDraft;
import io.sphere.sdk.products.ProductVariantDraftBuilder;
import io.sphere.sdk.products.attributes.Attribute;
import io.sphere.sdk.products.attributes.AttributeAccess;
import io.sphere.sdk.products.attributes.AttributeDraft;
import io.sphere.sdk.types.CustomFieldsDraft;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class VariantReferenceReplacementUtils {
    @Nonnull
    public static List<ProductVariantDraft> replaceVariantsReferenceIdsWithKeys(@Nonnull List<ProductVariant> productVariants) {
        return productVariants.stream().filter(Objects::nonNull).map(productVariant -> {
            List<PriceDraft> priceDraftsWithKeys = VariantReferenceReplacementUtils.replacePricesReferencesIdsWithKeys(productVariant);
            List<AttributeDraft> attributeDraftsWithKeys = VariantReferenceReplacementUtils.replaceAttributesReferencesIdsWithKeys(productVariant);
            List<AssetDraft> assetDraftsWithKeys = AssetReferenceReplacementUtils.replaceAssetsReferencesIdsWithKeys(productVariant.getAssets());
            return ((ProductVariantDraftBuilder)((ProductVariantDraftBuilder)((ProductVariantDraftBuilder)ProductVariantDraftBuilder.of((ProductVariant)productVariant).prices(priceDraftsWithKeys)).attributes(attributeDraftsWithKeys)).assets(assetDraftsWithKeys)).build();
        }).collect(Collectors.toList());
    }

    @Nonnull
    static List<PriceDraft> replacePricesReferencesIdsWithKeys(@Nonnull ProductVariant productVariant) {
        return productVariant.getPrices().stream().map(price -> {
            ResourceIdentifier<Channel> channelReferenceWithKey = VariantReferenceReplacementUtils.replaceChannelReferenceIdWithKey(price);
            CustomFieldsDraft customFieldsDraftWithKey = CustomTypeReferenceReplacementUtils.replaceCustomTypeIdWithKeys(price);
            return PriceDraftBuilder.of((Price)price).custom(customFieldsDraftWithKey).channel(channelReferenceWithKey).build();
        }).collect(Collectors.toList());
    }

    @Nullable
    static ResourceIdentifier<Channel> replaceChannelReferenceIdWithKey(@Nonnull Price price) {
        Reference priceChannel = price.getChannel();
        return SyncUtils.getResourceIdentifierWithKeyReplaced(priceChannel, () -> ResourceIdentifier.ofId((String)((Channel)priceChannel.getObj()).getKey()));
    }

    @Nonnull
    static List<AttributeDraft> replaceAttributesReferencesIdsWithKeys(@Nonnull ProductVariant productVariant) {
        return productVariant.getAttributes().stream().map(attribute -> VariantReferenceReplacementUtils.replaceAttributeReferenceIdWithKey(attribute).map(productReference -> AttributeDraft.of((String)attribute.getName(), (Object)productReference)).orElseGet(() -> VariantReferenceReplacementUtils.replaceAttributeReferenceSetIdsWithKeys(attribute).map(productReferenceSet -> AttributeDraft.of((String)attribute.getName(), (Object)productReferenceSet)).orElseGet(() -> AttributeDraft.of((String)attribute.getName(), (JsonNode)attribute.getValueAsJsonNode())))).collect(Collectors.toList());
    }

    static Optional<Reference<Product>> replaceAttributeReferenceIdWithKey(@Nonnull Attribute attribute) {
        return VariantReferenceReplacementUtils.getProductReference(attribute).map(productReference -> SyncUtils.getReferenceWithKeyReplaced(productReference, () -> Product.referenceOfId((String)((Product)productReference.getObj()).getKey())));
    }

    private static Optional<Reference<Product>> getProductReference(@Nonnull Attribute attribute) {
        return Optional.of(attribute).filter(VariantReferenceReplacementUtils::isProductReference).map(productReferenceAttribute -> (Reference)productReferenceAttribute.getValue(AttributeAccess.ofProductReference()));
    }

    static Optional<Set<Reference<Product>>> replaceAttributeReferenceSetIdsWithKeys(@Nonnull Attribute attribute) {
        return VariantReferenceReplacementUtils.getProductReferenceSet(attribute).map(productReferenceSet -> productReferenceSet.stream().map(productReference -> SyncUtils.getReferenceWithKeyReplaced(productReference, () -> Product.referenceOfId((String)((Product)productReference.getObj()).getKey()))).collect(Collectors.toSet()));
    }

    private static Optional<Set<Reference<Product>>> getProductReferenceSet(@Nonnull Attribute attribute) {
        return Optional.of(attribute).filter(VariantReferenceReplacementUtils::isProductReferenceSet).map(productReferenceSetAttribute -> (Set)productReferenceSetAttribute.getValue(AttributeAccess.ofProductReferenceSet()));
    }

    static boolean isProductReference(@Nonnull Attribute attribute) {
        JsonNode valueAsJsonNode = attribute.getValueAsJsonNode();
        return !(valueAsJsonNode instanceof ArrayNode) && VariantReferenceReplacementUtils.isValueAProductReference(valueAsJsonNode);
    }

    static boolean isProductReferenceSet(@Nonnull Attribute attribute) {
        Iterator setIterator;
        JsonNode valueAsJsonNode = attribute.getValueAsJsonNode();
        if (valueAsJsonNode instanceof ArrayNode && (setIterator = valueAsJsonNode.elements()).hasNext()) {
            return VariantReferenceReplacementUtils.isValueAProductReference((JsonNode)setIterator.next());
        }
        return false;
    }

    private static boolean isValueAProductReference(@Nonnull JsonNode valueAsJsonNode) {
        if (valueAsJsonNode.isContainerNode()) {
            JsonNode typeIdNode = valueAsJsonNode.get("typeId");
            return typeIdNode != null && Product.referenceTypeId().equals(typeIdNode.asText());
        }
        return false;
    }

    private VariantReferenceReplacementUtils() {
    }
}

