/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes;

import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.producttypes.ProductTypeSyncOptions;
import com.commercetools.sync.producttypes.helpers.ProductTypeSyncStatistics;
import com.commercetools.sync.producttypes.utils.ProductTypeSyncUtils;
import com.commercetools.sync.services.ProductTypeService;
import com.commercetools.sync.services.impl.ProductTypeServiceImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.producttypes.ProductTypeDraft;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ProductTypeSync
extends BaseSync<ProductTypeDraft, ProductTypeSyncStatistics, ProductTypeSyncOptions> {
    private static final String CTP_PRODUCT_TYPE_FETCH_FAILED = "Failed to fetch existing product types with keys: '%s'.";
    private static final String CTP_PRODUCT_TYPE_UPDATE_FAILED = "Failed to update product type with key: '%s'. Reason: %s";
    private static final String PRODUCT_TYPE_DRAFT_HAS_NO_KEY = "Failed to process product type draft without key.";
    private static final String PRODUCT_TYPE_DRAFT_IS_NULL = "Failed to process null product type draft.";
    private final ProductTypeService productTypeService;

    public ProductTypeSync(@Nonnull ProductTypeSyncOptions productTypeSyncOptions) {
        this(productTypeSyncOptions, new ProductTypeServiceImpl(productTypeSyncOptions));
    }

    ProductTypeSync(@Nonnull ProductTypeSyncOptions productTypeSyncOptions, @Nonnull ProductTypeService productTypeService) {
        super(new ProductTypeSyncStatistics(), productTypeSyncOptions);
        this.productTypeService = productTypeService;
    }

    @Override
    protected CompletionStage<ProductTypeSyncStatistics> process(@Nonnull List<ProductTypeDraft> productTypeDrafts) {
        List batches = SyncUtils.batchElements(productTypeDrafts, ((ProductTypeSyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture(this.statistics));
    }

    @Override
    protected CompletionStage<ProductTypeSyncStatistics> processBatch(@Nonnull List<ProductTypeDraft> batch) {
        Set validProductTypeDrafts = batch.stream().filter(this::validateDraft).collect(Collectors.toSet());
        if (validProductTypeDrafts.isEmpty()) {
            ((ProductTypeSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return CompletableFuture.completedFuture(this.statistics);
        }
        Set<String> keys = validProductTypeDrafts.stream().map(ProductTypeDraft::getKey).collect(Collectors.toSet());
        return this.productTypeService.fetchMatchingProductTypesByKeys(keys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Set fetchedProductTypes = (Set)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_PRODUCT_TYPE_FETCH_FAILED, keys);
                this.handleError(errorMessage, exception, keys.size());
                return CompletableFuture.completedFuture(null);
            }
            return this.syncBatch(fetchedProductTypes, validProductTypeDrafts);
        }).thenApply(ignored -> {
            ((ProductTypeSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (ProductTypeSyncStatistics)this.statistics;
        });
    }

    private boolean validateDraft(@Nullable ProductTypeDraft draft) {
        if (draft == null) {
            this.handleError(PRODUCT_TYPE_DRAFT_IS_NULL, null, 1);
        } else if (StringUtils.isBlank((CharSequence)draft.getKey())) {
            this.handleError(PRODUCT_TYPE_DRAFT_HAS_NO_KEY, null, 1);
        } else {
            return true;
        }
        return false;
    }

    private void handleError(@Nonnull String errorMessage, @Nullable Throwable exception, int failedTimes) {
        ((ProductTypeSyncOptions)this.syncOptions).applyErrorCallback(errorMessage, exception);
        ((ProductTypeSyncStatistics)this.statistics).incrementFailed(failedTimes);
    }

    @Nonnull
    private CompletionStage<Void> syncBatch(@Nonnull Set<ProductType> oldProductTypes, @Nonnull Set<ProductTypeDraft> newProductTypes) {
        Map oldProductTypeMap = oldProductTypes.stream().collect(Collectors.toMap(ProductType::getKey, Function.identity()));
        return CompletableFuture.allOf((CompletableFuture[])newProductTypes.stream().map(newProductType -> {
            ProductType oldProductType = (ProductType)oldProductTypeMap.get(newProductType.getKey());
            return Optional.ofNullable(oldProductType).map(productType -> this.buildActionsAndUpdate(oldProductType, (ProductTypeDraft)newProductType)).orElseGet(() -> this.applyCallbackAndCreate((ProductTypeDraft)newProductType));
        }).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    @Nonnull
    private CompletionStage<Optional<ProductType>> applyCallbackAndCreate(@Nonnull ProductTypeDraft productTypeDraft) {
        return ((ProductTypeSyncOptions)this.syncOptions).applyBeforeCreateCallBack(productTypeDraft).map(draft -> this.productTypeService.createProductType((ProductTypeDraft)draft).thenApply(productTypeOptional -> {
            if (productTypeOptional.isPresent()) {
                ((ProductTypeSyncStatistics)this.statistics).incrementCreated();
            } else {
                ((ProductTypeSyncStatistics)this.statistics).incrementFailed();
            }
            return productTypeOptional;
        })).orElse(CompletableFuture.completedFuture(Optional.empty()));
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Optional<ProductType>> buildActionsAndUpdate(@Nonnull ProductType oldProductType, @Nonnull ProductTypeDraft newProductType) {
        List updateActions = ProductTypeSyncUtils.buildActions(oldProductType, newProductType, (ProductTypeSyncOptions)this.syncOptions);
        List<UpdateAction<ProductType>> updateActionsAfterCallback = ((ProductTypeSyncOptions)this.syncOptions).applyBeforeUpdateCallBack(updateActions, newProductType, oldProductType);
        if (!updateActionsAfterCallback.isEmpty()) {
            return this.updateProductType(oldProductType, newProductType, updateActionsAfterCallback);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    private CompletionStage<Optional<ProductType>> updateProductType(@Nonnull ProductType oldProductType, @Nonnull ProductTypeDraft newProductType, @Nonnull List<UpdateAction<ProductType>> updateActions) {
        return this.productTypeService.updateProductType(oldProductType, updateActions).handle(ImmutablePair::new).thenCompose(updateResponse -> {
            ProductType updatedProductType = (ProductType)updateResponse.getKey();
            Throwable sphereException = (Throwable)updateResponse.getValue();
            if (sphereException != null) {
                return ProductTypeSync.executeSupplierIfConcurrentModificationException(sphereException, () -> this.fetchAndUpdate(oldProductType, newProductType), () -> {
                    String errorMessage = String.format(CTP_PRODUCT_TYPE_UPDATE_FAILED, newProductType.getKey(), sphereException.getMessage());
                    this.handleError(errorMessage, sphereException, 1);
                    return CompletableFuture.completedFuture(Optional.empty());
                });
            }
            ((ProductTypeSyncStatistics)this.statistics).incrementUpdated();
            return CompletableFuture.completedFuture(Optional.of(updatedProductType));
        });
    }

    @Nonnull
    private CompletionStage<Optional<ProductType>> fetchAndUpdate(@Nonnull ProductType oldProductType, @Nonnull ProductTypeDraft newProductType) {
        String key = oldProductType.getKey();
        return this.productTypeService.fetchProductType(key).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Optional fetchedProductTypeOptional = (Optional)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_PRODUCT_TYPE_UPDATE_FAILED, key, "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(errorMessage, exception, 1);
                return CompletableFuture.completedFuture(null);
            }
            return fetchedProductTypeOptional.map(fetchedProductType -> this.buildActionsAndUpdate((ProductType)fetchedProductType, newProductType)).orElseGet(() -> {
                String errorMessage = String.format(CTP_PRODUCT_TYPE_UPDATE_FAILED, key, "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(errorMessage, null, 1);
                return CompletableFuture.completedFuture(null);
            });
        });
    }
}

