/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.utils.SyncUtils;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.commands.DraftBasedCreateCommand;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.commands.UpdateCommand;
import io.sphere.sdk.models.Resource;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

class BaseService<T, U extends Resource<U>, S extends BaseSyncOptions> {
    final S syncOptions;
    boolean isCached = false;
    final Map<String, String> keyToIdCache = new ConcurrentHashMap<String, String>();
    private static final int MAXIMUM_ALLOWED_UPDATE_ACTIONS = 500;
    private static final String CREATE_FAILED = "Failed to create draft with key: '%s'. Reason: %s";

    BaseService(@Nonnull S syncOptions) {
        this.syncOptions = syncOptions;
    }

    @Nonnull
    CompletionStage<U> updateResource(@Nonnull U resource, @Nonnull BiFunction<U, List<? extends UpdateAction<U>>, UpdateCommand<U>> updateCommandFunction, @Nonnull List<UpdateAction<U>> updateActions) {
        List<List<UpdateAction<U>>> actionBatches = SyncUtils.batchElements(updateActions, 500);
        return this.updateBatches(CompletableFuture.completedFuture(resource), updateCommandFunction, actionBatches);
    }

    @Nonnull
    private CompletionStage<U> updateBatches(@Nonnull CompletionStage<U> result, @Nonnull BiFunction<U, List<? extends UpdateAction<U>>, UpdateCommand<U>> updateCommandFunction, @Nonnull List<List<UpdateAction<U>>> batches) {
        CompletionStage<U> resultStage = result;
        for (List<UpdateAction<U>> batch : batches) {
            resultStage = resultStage.thenCompose(updatedProduct -> ((BaseSyncOptions)this.syncOptions).getCtpClient().execute((SphereRequest)updateCommandFunction.apply(updatedProduct, batch)));
        }
        return resultStage;
    }

    @Nonnull
    CompletionStage<Optional<U>> createResource(@Nonnull T draft, @Nonnull Function<T, String> keyMapper, @Nonnull Function<T, DraftBasedCreateCommand<U, T>> createCommand) {
        String draftKey = keyMapper.apply(draft);
        if (StringUtils.isBlank((CharSequence)draftKey)) {
            ((BaseSyncOptions)this.syncOptions).applyErrorCallback(String.format(CREATE_FAILED, draftKey, "Draft key is blank!"));
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return ((BaseSyncOptions)this.syncOptions).getCtpClient().execute((SphereRequest)createCommand.apply(draft)).handle((resource, exception) -> {
            if (exception == null) {
                this.keyToIdCache.put(draftKey, resource.getId());
                return Optional.of(resource);
            }
            ((BaseSyncOptions)this.syncOptions).applyErrorCallback(String.format(CREATE_FAILED, draftKey, exception.getMessage()), (Throwable)exception);
            return Optional.empty();
        });
    }
}

