/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.cartdiscounts.CartDiscountSyncOptions;
import com.commercetools.sync.commons.utils.CtpQueryUtils;
import com.commercetools.sync.services.CartDiscountService;
import com.commercetools.sync.services.impl.BaseService;
import io.sphere.sdk.cartdiscounts.CartDiscount;
import io.sphere.sdk.cartdiscounts.CartDiscountDraft;
import io.sphere.sdk.cartdiscounts.commands.CartDiscountCreateCommand;
import io.sphere.sdk.cartdiscounts.commands.CartDiscountUpdateCommand;
import io.sphere.sdk.cartdiscounts.queries.CartDiscountQuery;
import io.sphere.sdk.cartdiscounts.queries.CartDiscountQueryBuilder;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.commands.UpdateAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class CartDiscountServiceImpl
extends BaseService<CartDiscountDraft, CartDiscount, CartDiscountSyncOptions>
implements CartDiscountService {
    public CartDiscountServiceImpl(@Nonnull CartDiscountSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<CartDiscount>> fetchMatchingCartDiscountsByKeys(@Nonnull Set<String> keys) {
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptySet());
        }
        CartDiscountQuery cartDiscountQuery = CartDiscountQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().isIn((Iterable)keys)).build();
        return CtpQueryUtils.queryAll(((CartDiscountSyncOptions)this.syncOptions).getCtpClient(), cartDiscountQuery, Function.identity()).thenApply(cartDiscounts -> cartDiscounts.stream().flatMap(Collection::stream).peek(cartDiscount -> this.keyToIdCache.put(cartDiscount.getKey(), cartDiscount.getId())).collect(Collectors.toSet()));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<CartDiscount>> fetchCartDiscount(@Nullable String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        CartDiscountQuery cartDiscountQuery = CartDiscountQuery.of().plusPredicates(cartDiscountQueryModel -> cartDiscountQueryModel.key().is(key));
        return ((CartDiscountSyncOptions)this.syncOptions).getCtpClient().execute((SphereRequest)cartDiscountQuery).thenApply(cartDiscountPagedQueryResult -> cartDiscountPagedQueryResult.head().map(cartDiscount -> {
            this.keyToIdCache.put(cartDiscount.getKey(), cartDiscount.getId());
            return cartDiscount;
        }));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<CartDiscount>> createCartDiscount(@Nonnull CartDiscountDraft cartDiscountDraft) {
        return this.createResource(cartDiscountDraft, CartDiscountDraft::getKey, CartDiscountCreateCommand::of);
    }

    @Override
    @Nonnull
    public CompletionStage<CartDiscount> updateCartDiscount(@Nonnull CartDiscount cartDiscount, @Nonnull List<UpdateAction<CartDiscount>> updateActions) {
        return this.updateResource(cartDiscount, CartDiscountUpdateCommand::of, updateActions);
    }
}

