/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.utils.CtpQueryUtils;
import com.commercetools.sync.services.CustomerGroupService;
import io.sphere.sdk.customergroups.queries.CustomerGroupQuery;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class CustomerGroupServiceImpl
implements CustomerGroupService {
    private final BaseSyncOptions syncOptions;
    private final Map<String, String> keyToIdCache = new ConcurrentHashMap<String, String>();
    public static final String CUSTOMER_GROUP_KEY_NOT_SET = "CustomerGroup with id: '%s' has no key set. Keys are required for customer group matching.";

    public CustomerGroupServiceImpl(@Nonnull BaseSyncOptions syncOptions) {
        this.syncOptions = syncOptions;
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedCustomerGroupId(@Nullable String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (this.keyToIdCache.isEmpty()) {
            return this.fetchAndCache(key);
        }
        return CompletableFuture.completedFuture(Optional.ofNullable(this.keyToIdCache.get(key)));
    }

    @Nonnull
    private CompletionStage<Optional<String>> fetchAndCache(@Nonnull String key) {
        Consumer customerGroupPageConsumer = customerGroupsPage -> customerGroupsPage.forEach(customerGroup -> {
            String fetchedCustomerGroupKey = customerGroup.getKey();
            String fetchedCustomerGroupId = customerGroup.getId();
            if (StringUtils.isNotBlank((CharSequence)fetchedCustomerGroupKey)) {
                this.keyToIdCache.put(fetchedCustomerGroupKey, fetchedCustomerGroupId);
            } else {
                this.syncOptions.applyWarningCallback(String.format(CUSTOMER_GROUP_KEY_NOT_SET, fetchedCustomerGroupId));
            }
        });
        return CtpQueryUtils.queryAll(this.syncOptions.getCtpClient(), CustomerGroupQuery.of(), customerGroupPageConsumer).thenApply(result -> Optional.ofNullable(this.keyToIdCache.get(key)));
    }
}

