/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.cartdiscounts.helpers;

import com.commercetools.sync.cartdiscounts.CartDiscountSyncOptions;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.services.TypeService;
import io.sphere.sdk.cartdiscounts.CartDiscountDraft;
import io.sphere.sdk.cartdiscounts.CartDiscountDraftBuilder;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public final class CartDiscountReferenceResolver
extends CustomReferenceResolver<CartDiscountDraft, CartDiscountDraftBuilder, CartDiscountSyncOptions> {
    private static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on CartDiscountDraft with key:'%s'.";

    public CartDiscountReferenceResolver(@Nonnull CartDiscountSyncOptions options, @Nonnull TypeService typeService) {
        super(options, typeService);
    }

    @Override
    @Nonnull
    public CompletionStage<CartDiscountDraft> resolveReferences(@Nonnull CartDiscountDraft draft) {
        return this.resolveCustomTypeReference(CartDiscountDraftBuilder.of((CartDiscountDraft)draft)).thenApply(rec$ -> ((CartDiscountDraftBuilder)rec$).build());
    }

    @Override
    protected CompletionStage<CartDiscountDraftBuilder> resolveCustomTypeReference(@Nonnull CartDiscountDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, rec$ -> ((CartDiscountDraftBuilder)rec$).getCustom(), (rec$, x$0) -> (CartDiscountDraftBuilder)((CartDiscountDraftBuilder)rec$).custom(x$0), String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getKey()));
    }
}

