/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.services.TypeService;
import io.sphere.sdk.models.AssetDraft;
import io.sphere.sdk.models.AssetDraftBuilder;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public final class AssetReferenceResolver
extends CustomReferenceResolver<AssetDraft, AssetDraftBuilder, BaseSyncOptions> {
    private static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on AssetDraft with key:'%s'.";

    public AssetReferenceResolver(@Nonnull BaseSyncOptions options, @Nonnull TypeService typeService) {
        super(options, typeService);
    }

    @Override
    @Nonnull
    public CompletionStage<AssetDraft> resolveReferences(@Nonnull AssetDraft assetDraft) {
        return this.resolveCustomTypeReference(AssetDraftBuilder.of((AssetDraft)assetDraft)).thenApply(rec$ -> ((AssetDraftBuilder)rec$).build());
    }

    @Override
    @Nonnull
    protected CompletionStage<AssetDraftBuilder> resolveCustomTypeReference(@Nonnull AssetDraftBuilder assetDraftBuilder) {
        return this.resolveCustomTypeReference(assetDraftBuilder, rec$ -> ((AssetDraftBuilder)rec$).getCustom(), (rec$, x$0) -> (AssetDraftBuilder)((AssetDraftBuilder)rec$).custom(x$0), String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, assetDraftBuilder.getKey()));
    }
}

