/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CollectionUtils {
    @Nonnull
    public static <T> Stream<T> filterCollection(@Nullable Collection<T> collection, @Nonnull Predicate<T> includeCondition) {
        return collection == null ? Stream.empty() : collection.stream().filter(includeCondition);
    }

    @Nonnull
    public static <T, K> Set<K> collectionToSet(@Nullable Collection<T> collection, @Nonnull Function<? super T, ? extends K> keyMapper) {
        return CollectionUtils.emptyIfNull(collection).stream().map(keyMapper).collect(Collectors.toSet());
    }

    @Nonnull
    public static <T, K, V> Map<K, V> collectionToMap(@Nullable Collection<T> collection, @Nonnull Function<? super T, ? extends K> keyMapper, @Nonnull Function<? super T, ? extends V> valueMapper) {
        return CollectionUtils.emptyIfNull(collection).stream().collect(Collectors.toMap(keyMapper, valueMapper, (k1, k2) -> k1));
    }

    @Nonnull
    public static <T, K> Map<K, T> collectionToMap(@Nullable Collection<T> collection, @Nonnull Function<? super T, ? extends K> keyMapper) {
        return CollectionUtils.collectionToMap(collection, keyMapper, value -> value);
    }

    @Nonnull
    public static <T> Collection<T> emptyIfNull(@Nullable Collection<T> collection) {
        return collection == null ? Collections.emptyList() : collection;
    }

    @Nonnull
    public static <T> List<T> emptyIfNull(@Nullable List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    @Nonnull
    public static <T> Set<T> emptyIfNull(@Nullable Set<T> set) {
        return set == null ? Collections.emptySet() : set;
    }

    @Nonnull
    public static <K, V> Map<K, V> emptyIfNull(@Nullable Map<K, V> map) {
        return map == null ? Collections.emptyMap() : map;
    }

    private CollectionUtils() {
    }
}

