/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.utils;

import com.commercetools.sync.commons.utils.CustomTypeReferenceReplacementUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import io.sphere.sdk.channels.Channel;
import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import io.sphere.sdk.inventory.InventoryEntryDraftBuilder;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.types.CustomFieldsDraft;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class InventoryReferenceReplacementUtils {
    @Nonnull
    public static List<InventoryEntryDraft> replaceInventoriesReferenceIdsWithKeys(@Nonnull List<InventoryEntry> inventoryEntries) {
        return inventoryEntries.stream().map(inventoryEntry -> {
            CustomFieldsDraft customTypeWithKeysInReference = CustomTypeReferenceReplacementUtils.replaceCustomTypeIdWithKeys(inventoryEntry);
            ResourceIdentifier<Channel> channelReferenceWithKeysInReference = InventoryReferenceReplacementUtils.replaceChannelReferenceIdWithKey(inventoryEntry);
            return InventoryEntryDraftBuilder.of((InventoryEntry)inventoryEntry).custom(customTypeWithKeysInReference).supplyChannel(channelReferenceWithKeysInReference).build();
        }).collect(Collectors.toList());
    }

    @Nullable
    static ResourceIdentifier<Channel> replaceChannelReferenceIdWithKey(@Nonnull InventoryEntry inventoryEntry) {
        Reference inventoryEntrySupplyChannel = inventoryEntry.getSupplyChannel();
        return SyncUtils.getResourceIdentifierWithKeyReplaced(inventoryEntrySupplyChannel, () -> ResourceIdentifier.ofId((String)((Channel)inventoryEntrySupplyChannel.getObj()).getKey()));
    }

    private InventoryReferenceReplacementUtils() {
    }
}

