/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products;

import com.commercetools.sync.categories.CategorySyncOptionsBuilder;
import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.ProductBatchProcessor;
import com.commercetools.sync.products.helpers.ProductReferenceResolver;
import com.commercetools.sync.products.helpers.ProductSyncStatistics;
import com.commercetools.sync.products.utils.ProductSyncUtils;
import com.commercetools.sync.services.CategoryService;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.CustomerGroupService;
import com.commercetools.sync.services.ProductService;
import com.commercetools.sync.services.ProductTypeService;
import com.commercetools.sync.services.StateService;
import com.commercetools.sync.services.TaxCategoryService;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.impl.CategoryServiceImpl;
import com.commercetools.sync.services.impl.ChannelServiceImpl;
import com.commercetools.sync.services.impl.CustomerGroupServiceImpl;
import com.commercetools.sync.services.impl.ProductServiceImpl;
import com.commercetools.sync.services.impl.ProductTypeServiceImpl;
import com.commercetools.sync.services.impl.StateServiceImpl;
import com.commercetools.sync.services.impl.TaxCategoryServiceImpl;
import com.commercetools.sync.services.impl.TypeServiceImpl;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.states.StateType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ProductSync
extends BaseSync<ProductDraft, ProductSyncStatistics, ProductSyncOptions> {
    private static final String UPDATE_FAILED = "Failed to update Product with key: '%s'. Reason: %s";
    private static final String FAILED_TO_RESOLVE_REFERENCES = "Failed to resolve references on ProductDraft with key:'%s'. Reason: %s";
    private static final String FAILED_TO_FETCH_PRODUCT_TYPE = "Failed to fetch a productType for the product to build the products' attributes metadata.";
    private final ProductService productService;
    private final ProductTypeService productTypeService;
    private final ProductReferenceResolver productReferenceResolver;
    private Map<ProductDraft, Product> productsToSync = new HashMap<ProductDraft, Product>();
    private Set<ProductDraft> existingDrafts = new HashSet<ProductDraft>();
    private Set<ProductDraft> draftsToCreate = new HashSet<ProductDraft>();

    public ProductSync(@Nonnull ProductSyncOptions productSyncOptions) {
        this(productSyncOptions, new ProductServiceImpl(productSyncOptions), new ProductTypeServiceImpl(productSyncOptions), new CategoryServiceImpl(CategorySyncOptionsBuilder.of(productSyncOptions.getCtpClient()).build()), new TypeServiceImpl(productSyncOptions), new ChannelServiceImpl(productSyncOptions), new CustomerGroupServiceImpl(productSyncOptions), new TaxCategoryServiceImpl(productSyncOptions), new StateServiceImpl(productSyncOptions, StateType.PRODUCT_STATE));
    }

    ProductSync(@Nonnull ProductSyncOptions productSyncOptions, @Nonnull ProductService productService, @Nonnull ProductTypeService productTypeService, @Nonnull CategoryService categoryService, @Nonnull TypeService typeService, @Nonnull ChannelService channelService, @Nonnull CustomerGroupService customerGroupService, @Nonnull TaxCategoryService taxCategoryService, @Nonnull StateService stateService) {
        super(new ProductSyncStatistics(), productSyncOptions);
        this.productService = productService;
        this.productTypeService = productTypeService;
        this.productReferenceResolver = new ProductReferenceResolver(productSyncOptions, productTypeService, categoryService, typeService, channelService, customerGroupService, taxCategoryService, stateService, productService);
    }

    @Override
    protected CompletionStage<ProductSyncStatistics> process(@Nonnull List<ProductDraft> resourceDrafts) {
        List batches = SyncUtils.batchElements(resourceDrafts, ((ProductSyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture(this.statistics));
    }

    @Override
    protected CompletionStage<ProductSyncStatistics> processBatch(@Nonnull List<ProductDraft> batch) {
        this.productsToSync = new HashMap<ProductDraft, Product>();
        this.draftsToCreate = new HashSet<ProductDraft>();
        this.existingDrafts = new HashSet<ProductDraft>();
        ProductBatchProcessor batchProcessor = new ProductBatchProcessor(batch, this);
        batchProcessor.validateBatch();
        Set<String> keysToCache = batchProcessor.getKeysToCache();
        return this.productService.cacheKeysToIds(keysToCache).handle(ImmutablePair::new).thenCompose(cachingResponse -> {
            Map keyToIdCache = (Map)cachingResponse.getKey();
            Throwable cachingException = (Throwable)cachingResponse.getValue();
            if (cachingException != null) {
                this.handleError("Failed to build a cache of keys to ids.", cachingException, keysToCache.size());
                return CompletableFuture.completedFuture(null);
            }
            this.prepareDraftsForProcessing(batchProcessor.getValidDrafts(), keyToIdCache);
            Set<String> productDraftKeys = this.getProductDraftKeys(this.existingDrafts);
            return this.productService.fetchMatchingProductsByKeys(productDraftKeys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
                Set fetchedProducts = (Set)fetchResponse.getKey();
                Throwable fetchException = (Throwable)fetchResponse.getValue();
                if (fetchException != null) {
                    String errorMessage = String.format("Failed to fetch existing products with keys: '%s'.", productDraftKeys);
                    this.handleError(errorMessage, fetchException, productDraftKeys.size());
                    return CompletableFuture.completedFuture(null);
                }
                this.processFetchedProducts(fetchedProducts);
                return this.createAndUpdateProducts();
            });
        }).thenApply(ignoredResult -> {
            ((ProductSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (ProductSyncStatistics)this.statistics;
        });
    }

    private void prepareDraftsForProcessing(@Nonnull Set<ProductDraft> productDrafts, @Nonnull Map<String, String> keyToIdCache) {
        productDrafts.forEach(productDraft -> this.productReferenceResolver.resolveReferences((ProductDraft)productDraft).thenAccept(referencesResolvedDraft -> {
            if (keyToIdCache.containsKey(productDraft.getKey())) {
                this.existingDrafts.add((ProductDraft)referencesResolvedDraft);
            } else {
                this.draftsToCreate.add((ProductDraft)referencesResolvedDraft);
            }
        }).exceptionally(referenceResolutionException -> {
            Throwable actualException = referenceResolutionException;
            if (referenceResolutionException instanceof CompletionException) {
                actualException = referenceResolutionException.getCause();
            }
            String errorMessage = String.format(FAILED_TO_RESOLVE_REFERENCES, productDraft.getKey(), actualException);
            this.handleError(errorMessage, actualException);
            return null;
        }).toCompletableFuture().join());
    }

    @Nonnull
    private Set<String> getProductDraftKeys(@Nonnull Set<ProductDraft> productDrafts) {
        return productDrafts.stream().map(ProductDraft::getKey).collect(Collectors.toSet());
    }

    private void processFetchedProducts(@Nonnull Set<Product> fetchedProducts) {
        this.existingDrafts.forEach(existingDraft -> ProductSync.getProductByKeyIfExists(fetchedProducts, Objects.requireNonNull(existingDraft.getKey())).ifPresent(product -> this.productsToSync.put((ProductDraft)existingDraft, (Product)product)));
    }

    @Nonnull
    private static Optional<Product> getProductByKeyIfExists(@Nonnull Set<Product> products, @Nonnull String key) {
        return products.stream().filter(product -> Objects.equals(product.getKey(), key)).findFirst();
    }

    @Nonnull
    private CompletableFuture<Void> createAndUpdateProducts() {
        CompletableFuture<Void> createRequestsStage = this.createProducts(this.draftsToCreate).thenAccept(createdProducts -> this.updateStatistics((Set<Product>)createdProducts, this.draftsToCreate.size())).toCompletableFuture();
        CompletableFuture<List<Optional<Product>>> updateRequestsStage = this.syncProducts(this.productsToSync).toCompletableFuture();
        return CompletableFuture.allOf(createRequestsStage, updateRequestsStage);
    }

    @Nonnull
    private CompletionStage<Set<Product>> createProducts(@Nonnull Set<ProductDraft> productsDrafts) {
        return ((CompletableFuture)CompletableFutureUtils.mapValuesToFutureOfCompletedValues(productsDrafts, this::applyCallbackAndCreate).thenApply(results -> results.filter(Optional::isPresent).map(Optional::get))).thenApply(createdProducts -> createdProducts.collect(Collectors.toSet()));
    }

    @Nonnull
    private CompletionStage<Optional<Product>> applyCallbackAndCreate(@Nonnull ProductDraft productDraft) {
        return ((ProductSyncOptions)this.syncOptions).applyBeforeCreateCallBack(productDraft).map(this.productService::createProduct).orElse(CompletableFuture.completedFuture(Optional.empty()));
    }

    private void updateStatistics(@Nonnull Set<Product> createdProducts, int totalNumberOfDraftsToCreate) {
        int numberOfFailedCreations = totalNumberOfDraftsToCreate - createdProducts.size();
        ((ProductSyncStatistics)this.statistics).incrementFailed(numberOfFailedCreations);
        ((ProductSyncStatistics)this.statistics).incrementCreated(createdProducts.size());
    }

    @Nonnull
    private CompletionStage<List<Optional<Product>>> syncProducts(@Nonnull Map<ProductDraft, Product> productsToSync) {
        return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(productsToSync.entrySet(), entry -> this.fetchProductAttributesMetadataAndUpdate((Product)entry.getValue(), (ProductDraft)entry.getKey()), Collectors.toList());
    }

    @Nonnull
    private CompletionStage<Optional<Product>> fetchProductAttributesMetadataAndUpdate(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        return this.productTypeService.fetchCachedProductAttributeMetaDataMap(oldProduct.getProductType().getId()).thenCompose(optionalAttributesMetaDataMap -> optionalAttributesMetaDataMap.map(attributeMetaDataMap -> {
            List updateActions = ProductSyncUtils.buildActions(oldProduct, newProduct, (ProductSyncOptions)this.syncOptions, attributeMetaDataMap);
            List<UpdateAction<Product>> beforeUpdateCallBackApplied = ((ProductSyncOptions)this.syncOptions).applyBeforeUpdateCallBack(updateActions, newProduct, oldProduct);
            if (!beforeUpdateCallBackApplied.isEmpty()) {
                return this.updateProduct(oldProduct, newProduct, beforeUpdateCallBackApplied);
            }
            return CompletableFuture.completedFuture(Optional.of(oldProduct));
        }).orElseGet(() -> {
            String errorMessage = String.format(UPDATE_FAILED, oldProduct.getKey(), FAILED_TO_FETCH_PRODUCT_TYPE);
            this.handleError(errorMessage);
            return CompletableFuture.completedFuture(Optional.of(oldProduct));
        }));
    }

    @Nonnull
    private CompletionStage<Optional<Product>> updateProduct(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct, @Nonnull List<UpdateAction<Product>> updateActions) {
        return this.productService.updateProduct(oldProduct, updateActions).handle(ImmutablePair::new).thenCompose(updateResponse -> {
            Product updatedProduct = (Product)updateResponse.getKey();
            Throwable sphereException = (Throwable)updateResponse.getValue();
            if (sphereException != null) {
                return ProductSync.executeSupplierIfConcurrentModificationException(sphereException, () -> this.fetchAndUpdate(oldProduct, newProduct), () -> {
                    String productKey = oldProduct.getKey();
                    this.handleError(String.format(UPDATE_FAILED, productKey, sphereException), sphereException);
                    return CompletableFuture.completedFuture(Optional.empty());
                });
            }
            ((ProductSyncStatistics)this.statistics).incrementUpdated();
            return CompletableFuture.completedFuture(Optional.of(updatedProduct));
        });
    }

    @Nonnull
    private CompletionStage<Optional<Product>> fetchAndUpdate(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        String key = oldProduct.getKey();
        return this.productService.fetchProduct(key).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Optional fetchedProductOptional = (Optional)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(UPDATE_FAILED, key, "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(errorMessage, exception);
                return CompletableFuture.completedFuture(Optional.empty());
            }
            return fetchedProductOptional.map(fetchedProduct -> this.fetchProductAttributesMetadataAndUpdate((Product)fetchedProduct, newProduct)).orElseGet(() -> {
                String errorMessage = String.format(UPDATE_FAILED, key, "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(errorMessage);
                return CompletableFuture.completedFuture(Optional.empty());
            });
        });
    }

    private void handleError(@Nonnull String errorMessage) {
        this.handleError(errorMessage, null);
    }

    private void handleError(@Nonnull String errorMessage, @Nullable Throwable exception) {
        ((ProductSyncOptions)this.syncOptions).applyErrorCallback(errorMessage, exception);
        ((ProductSyncStatistics)this.statistics).incrementFailed();
    }

    private void handleError(@Nonnull String errorMessage, @Nullable Throwable exception, int failedTimes) {
        ((ProductSyncOptions)this.syncOptions).applyErrorCallback(errorMessage, exception);
        ((ProductSyncStatistics)this.statistics).incrementFailed(failedTimes);
    }
}

