/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.helpers;

import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.CustomerGroupService;
import com.commercetools.sync.services.TypeService;
import io.sphere.sdk.channels.Channel;
import io.sphere.sdk.customergroups.CustomerGroup;
import io.sphere.sdk.models.Referenceable;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.products.PriceDraft;
import io.sphere.sdk.products.PriceDraftBuilder;
import io.sphere.sdk.utils.CompletableFutureUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PriceReferenceResolver
extends CustomReferenceResolver<PriceDraft, PriceDraftBuilder, ProductSyncOptions> {
    private ChannelService channelService;
    private CustomerGroupService customerGroupService;
    private static final String CHANNEL_DOES_NOT_EXIST = "Channel with key '%s' does not exist.";
    private static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on PriceDraft with country:'%s' and value: '%s'.";
    private static final String FAILED_TO_RESOLVE_REFERENCE = "Failed to resolve '%s' reference on PriceDraft with country:'%s' and value: '%s'. Reason: %s";

    public PriceReferenceResolver(@Nonnull ProductSyncOptions options, @Nonnull TypeService typeService, @Nonnull ChannelService channelService, @Nonnull CustomerGroupService customerGroupService) {
        super(options, typeService);
        this.channelService = channelService;
        this.customerGroupService = customerGroupService;
    }

    @Override
    public CompletionStage<PriceDraft> resolveReferences(@Nonnull PriceDraft priceDraft) {
        return this.resolveCustomTypeReference(PriceDraftBuilder.of((PriceDraft)priceDraft)).thenCompose(this::resolveChannelReference).thenCompose(this::resolveCustomerGroupReference).thenApply(PriceDraftBuilder::build);
    }

    @Override
    @Nonnull
    protected CompletionStage<PriceDraftBuilder> resolveCustomTypeReference(@Nonnull PriceDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, PriceDraftBuilder::getCustom, PriceDraftBuilder::custom, String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getCountry(), draftBuilder.getValue()));
    }

    @Nonnull
    CompletionStage<PriceDraftBuilder> resolveChannelReference(@Nonnull PriceDraftBuilder draftBuilder) {
        return this.resolveReference(draftBuilder, draftBuilder.getChannel(), this.channelService::fetchCachedChannelId, ResourceIdentifier::ofId, (priceDraftBuilder, reference) -> CompletableFuture.completedFuture(priceDraftBuilder.channel(reference)), (priceDraftBuilder, channelKey) -> {
            CompletableFuture result = new CompletableFuture();
            this.createChannelAndSetReference((String)channelKey, (PriceDraftBuilder)priceDraftBuilder).whenComplete((draftWithCreatedChannel, exception) -> {
                if (exception != null) {
                    result.completeExceptionally(new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, Channel.referenceTypeId(), draftBuilder.getCountry(), draftBuilder.getValue(), exception.getMessage()), (Throwable)exception));
                } else {
                    result.complete(draftWithCreatedChannel);
                }
            });
            return result;
        });
    }

    @Nonnull
    private <T, S extends ResourceIdentifier<T>> CompletionStage<PriceDraftBuilder> resolveReference(@Nonnull PriceDraftBuilder draftBuilder, @Nullable S reference, @Nonnull Function<String, CompletionStage<Optional<String>>> keyToIdMapper, @Nonnull Function<String, S> idToReferenceMapper, @Nonnull BiFunction<PriceDraftBuilder, S, CompletionStage<PriceDraftBuilder>> referenceSetter, @Nonnull BiFunction<PriceDraftBuilder, String, CompletionStage<PriceDraftBuilder>> nonExistingReferenceDraftMapper) {
        if (reference == null) {
            return CompletableFuture.completedFuture(draftBuilder);
        }
        try {
            String resourceKey = PriceReferenceResolver.getKeyFromResourceIdentifier(reference);
            return keyToIdMapper.apply(resourceKey).thenCompose(resourceIdOptional -> resourceIdOptional.map(idToReferenceMapper).map(referenceToSet -> (CompletionStage)referenceSetter.apply(draftBuilder, referenceToSet)).orElseGet(() -> (CompletionStage)nonExistingReferenceDraftMapper.apply(draftBuilder, resourceKey)));
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, reference.getTypeId(), draftBuilder.getCountry(), draftBuilder.getValue(), referenceResolutionException.getMessage())));
        }
    }

    @Nonnull
    private CompletionStage<PriceDraftBuilder> createChannelAndSetReference(@Nonnull String channelKey, @Nonnull PriceDraftBuilder draftBuilder) {
        if (((ProductSyncOptions)this.options).shouldEnsurePriceChannels()) {
            return this.channelService.createAndCacheChannel(channelKey).thenApply(arg_0 -> ((PriceDraftBuilder)draftBuilder).channel(arg_0));
        }
        ReferenceResolutionException referenceResolutionException = new ReferenceResolutionException(String.format(CHANNEL_DOES_NOT_EXIST, channelKey));
        return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)referenceResolutionException);
    }

    @Nonnull
    CompletionStage<PriceDraftBuilder> resolveCustomerGroupReference(@Nonnull PriceDraftBuilder draftBuilder) {
        return this.resolveReference(draftBuilder, draftBuilder.getCustomerGroup(), this.customerGroupService::fetchCachedCustomerGroupId, CustomerGroup::referenceOfId, (priceDraftBuilder, reference) -> CompletableFuture.completedFuture(priceDraftBuilder.customerGroup((Referenceable)reference)), (priceDraftBuilder, customerGroupKey) -> CompletableFuture.completedFuture(priceDraftBuilder));
    }
}

