/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.helpers;

import com.commercetools.sync.products.ProductSync;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.ProductSyncStatistics;
import com.commercetools.sync.products.helpers.VariantReferenceResolver;
import com.fasterxml.jackson.databind.JsonNode;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.ProductVariantDraft;
import io.sphere.sdk.products.attributes.AttributeDraft;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ProductBatchProcessor {
    static final String PRODUCT_DRAFT_KEY_NOT_SET = "ProductDraft with name: %s doesn't have a key. Please make sure all product drafts have keys.";
    static final String PRODUCT_DRAFT_IS_NULL = "ProductDraft is null.";
    static final String PRODUCT_VARIANT_DRAFT_IS_NULL = "ProductVariantDraft at position '%d' of ProductDraft with key '%s' is null.";
    static final String PRODUCT_VARIANT_DRAFT_SKU_NOT_SET = "ProductVariantDraft at position '%d' of ProductDraft with key '%s' has no SKU set. Please make sure all variants have SKUs.";
    static final String PRODUCT_VARIANT_DRAFT_KEY_NOT_SET = "ProductVariantDraft at position '%d' of ProductDraft with key '%s' has no key set. Please make sure all variants have keys.";
    private final List<ProductDraft> productDrafts;
    private final ProductSync productSync;
    private final Set<ProductDraft> validDrafts = new HashSet<ProductDraft>();
    private final Set<String> keysToCache = new HashSet<String>();

    public ProductBatchProcessor(@Nonnull List<ProductDraft> productDrafts, @Nonnull ProductSync productSync) {
        this.productDrafts = productDrafts;
        this.productSync = productSync;
    }

    public void validateBatch() {
        for (ProductDraft productDraft : this.productDrafts) {
            if (productDraft != null) {
                String productKey = productDraft.getKey();
                if (StringUtils.isNotBlank((CharSequence)productKey)) {
                    Consumer<ProductVariantDraft> productVariantDraftConsumer = productVariantDraft -> this.keysToCache.addAll(ProductBatchProcessor.getReferencedProductKeys(productVariantDraft));
                    List<String> draftErrors = ProductBatchProcessor.getProductDraftErrorsAndAcceptConsumer(productDraft, productVariantDraftConsumer);
                    if (!draftErrors.isEmpty()) {
                        this.handleError(draftErrors);
                        continue;
                    }
                    this.keysToCache.add(productKey);
                    this.validDrafts.add(productDraft);
                    continue;
                }
                String errorMessage = String.format(PRODUCT_DRAFT_KEY_NOT_SET, productDraft.getName());
                this.handleError(errorMessage);
                continue;
            }
            this.handleError(PRODUCT_DRAFT_IS_NULL);
        }
    }

    @Nonnull
    static Set<String> getReferencedProductKeys(@Nonnull ProductVariantDraft variantDraft) {
        List attributeDrafts = variantDraft.getAttributes();
        if (attributeDrafts == null) {
            return Collections.emptySet();
        }
        return attributeDrafts.stream().filter(Objects::nonNull).map(ProductBatchProcessor::getReferencedProductKeys).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Nonnull
    static Set<String> getReferencedProductKeys(@Nonnull AttributeDraft attributeDraft) {
        JsonNode attributeDraftValue = attributeDraft.getValue();
        if (attributeDraftValue == null) {
            return Collections.emptySet();
        }
        return attributeDraftValue.isArray() ? ProductBatchProcessor.getReferencedProductKeysFromSet(attributeDraftValue) : ProductBatchProcessor.getProductKeyFromReference(attributeDraftValue).map(Collections::singleton).orElse(Collections.emptySet());
    }

    @Nonnull
    static Set<String> getReferencedProductKeysFromSet(@Nonnull JsonNode referenceSet) {
        return StreamSupport.stream(referenceSet.spliterator(), false).filter(Objects::nonNull).map(ProductBatchProcessor::getProductKeyFromReference).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    @Nonnull
    static Optional<String> getProductKeyFromReference(@Nonnull JsonNode referenceValue) {
        return VariantReferenceResolver.isProductReference(referenceValue) ? Optional.ofNullable(referenceValue.get("id")).map(JsonNode::asText) : Optional.empty();
    }

    @Nonnull
    static List<String> getProductDraftErrorsAndAcceptConsumer(@Nonnull ProductDraft productDraft, @Nonnull Consumer<ProductVariantDraft> variantConsumer) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<ProductVariantDraft> allVariants = new ArrayList<ProductVariantDraft>();
        allVariants.add(productDraft.getMasterVariant());
        if (productDraft.getVariants() != null) {
            allVariants.addAll(productDraft.getVariants());
        }
        for (int i = 0; i < allVariants.size(); ++i) {
            errorMessages.addAll(ProductBatchProcessor.getVariantDraftErrors((ProductVariantDraft)allVariants.get(i), i, Objects.requireNonNull(productDraft.getKey())));
        }
        if (errorMessages.isEmpty()) {
            allVariants.forEach(variantConsumer);
        }
        return errorMessages;
    }

    @Nonnull
    static List<String> getVariantDraftErrors(@Nullable ProductVariantDraft productVariantDraft, int variantPosition, @Nonnull String productDraftKey) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (productVariantDraft != null) {
            if (StringUtils.isBlank((CharSequence)productVariantDraft.getKey())) {
                errorMessages.add(String.format(PRODUCT_VARIANT_DRAFT_KEY_NOT_SET, variantPosition, productDraftKey));
            }
            if (StringUtils.isBlank((CharSequence)productVariantDraft.getSku())) {
                errorMessages.add(String.format(PRODUCT_VARIANT_DRAFT_SKU_NOT_SET, variantPosition, productDraftKey));
            }
        } else {
            errorMessages.add(String.format(PRODUCT_VARIANT_DRAFT_IS_NULL, variantPosition, productDraftKey));
        }
        return errorMessages;
    }

    private void handleError(@Nonnull List<String> errorMessages) {
        errorMessages.forEach(((ProductSyncOptions)this.productSync.getSyncOptions())::applyErrorCallback);
        ((ProductSyncStatistics)this.productSync.getStatistics()).incrementFailed();
    }

    private void handleError(@Nonnull String errorMessage) {
        ((ProductSyncOptions)this.productSync.getSyncOptions()).applyErrorCallback(errorMessage);
        ((ProductSyncStatistics)this.productSync.getStatistics()).incrementFailed();
    }

    public Set<ProductDraft> getValidDrafts() {
        return this.validDrafts;
    }

    public Set<String> getKeysToCache() {
        return this.keysToCache;
    }
}

