/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.helpers;

import com.commercetools.sync.commons.helpers.AssetReferenceResolver;
import com.commercetools.sync.commons.helpers.BaseReferenceResolver;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.PriceReferenceResolver;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.CustomerGroupService;
import com.commercetools.sync.services.ProductService;
import com.commercetools.sync.services.TypeService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductVariantDraft;
import io.sphere.sdk.products.ProductVariantDraftBuilder;
import io.sphere.sdk.products.attributes.AttributeDraft;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public final class VariantReferenceResolver
extends BaseReferenceResolver<ProductVariantDraft, ProductSyncOptions> {
    private final PriceReferenceResolver priceReferenceResolver;
    private final AssetReferenceResolver assetReferenceResolver;
    private final ProductService productService;
    public static final String REFERENCE_TYPE_ID_FIELD = "typeId";
    public static final String REFERENCE_ID_FIELD = "id";

    public VariantReferenceResolver(@Nonnull ProductSyncOptions productSyncOptions, @Nonnull TypeService typeService, @Nonnull ChannelService channelService, @Nonnull CustomerGroupService customerGroupService, @Nonnull ProductService productService) {
        super(productSyncOptions);
        this.priceReferenceResolver = new PriceReferenceResolver(productSyncOptions, typeService, channelService, customerGroupService);
        this.assetReferenceResolver = new AssetReferenceResolver(productSyncOptions, typeService);
        this.productService = productService;
    }

    @Override
    public CompletionStage<ProductVariantDraft> resolveReferences(@Nonnull ProductVariantDraft productVariantDraft) {
        return this.resolvePricesReferences(ProductVariantDraftBuilder.of((ProductVariantDraft)productVariantDraft)).thenCompose(this::resolveAssetsReferences).thenCompose(this::resolveAttributesReferences).thenApply(rec$ -> ((ProductVariantDraftBuilder)rec$).build());
    }

    @Nonnull
    CompletionStage<ProductVariantDraftBuilder> resolveAssetsReferences(@Nonnull ProductVariantDraftBuilder productVariantDraftBuilder) {
        List productVariantDraftAssets = productVariantDraftBuilder.getAssets();
        if (productVariantDraftAssets == null) {
            return CompletableFuture.completedFuture(productVariantDraftBuilder);
        }
        return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(productVariantDraftAssets, this.assetReferenceResolver::resolveReferences, Collectors.toList()).thenApply(x$0 -> (ProductVariantDraftBuilder)productVariantDraftBuilder.assets(x$0));
    }

    @Nonnull
    CompletionStage<ProductVariantDraftBuilder> resolvePricesReferences(@Nonnull ProductVariantDraftBuilder productVariantDraftBuilder) {
        List productVariantDraftPrices = productVariantDraftBuilder.getPrices();
        if (productVariantDraftPrices == null) {
            return CompletableFuture.completedFuture(productVariantDraftBuilder);
        }
        return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(productVariantDraftPrices, this.priceReferenceResolver::resolveReferences, Collectors.toList()).thenApply(x$0 -> (ProductVariantDraftBuilder)productVariantDraftBuilder.prices(x$0));
    }

    @Nonnull
    CompletionStage<ProductVariantDraftBuilder> resolveAttributesReferences(@Nonnull ProductVariantDraftBuilder productVariantDraftBuilder) {
        List attributeDrafts = productVariantDraftBuilder.getAttributes();
        if (attributeDrafts == null) {
            return CompletableFuture.completedFuture(productVariantDraftBuilder);
        }
        return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(attributeDrafts, this::resolveAttributeReference, Collectors.toList()).thenApply(x$0 -> (ProductVariantDraftBuilder)productVariantDraftBuilder.attributes(x$0));
    }

    @Nonnull
    CompletionStage<AttributeDraft> resolveAttributeReference(@Nonnull AttributeDraft attributeDraft) {
        JsonNode attributeDraftValue = attributeDraft.getValue();
        if (attributeDraftValue == null) {
            return CompletableFuture.completedFuture(attributeDraft);
        }
        if (attributeDraftValue.isArray()) {
            return this.resolveAttributeSetReferences(attributeDraft);
        }
        if (VariantReferenceResolver.isProductReference(attributeDraftValue)) {
            return this.getResolvedIdFromKeyInReference(attributeDraftValue).thenApply(productIdOptional -> productIdOptional.map(productId -> AttributeDraft.of((String)attributeDraft.getName(), (JsonNode)this.createProductReferenceJson((String)productId))).orElse(attributeDraft));
        }
        return CompletableFuture.completedFuture(attributeDraft);
    }

    @Nonnull
    private CompletionStage<AttributeDraft> resolveAttributeSetReferences(@Nonnull AttributeDraft attributeDraft) {
        JsonNode attributeDraftValue = attributeDraft.getValue();
        Spliterator attributeReferencesIterator = attributeDraftValue.spliterator();
        Stream<JsonNode> attributeReferenceStream = StreamSupport.stream(attributeReferencesIterator, false).filter(Objects::nonNull).filter(reference -> !reference.isNull());
        return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(attributeReferenceStream, this::resolveAttributeReferenceValue, Collectors.toList()).thenApply(resolved -> AttributeDraft.of((String)attributeDraft.getName(), (Object)resolved));
    }

    @Nonnull
    private CompletionStage<JsonNode> resolveAttributeReferenceValue(@Nonnull JsonNode referenceValue) {
        if (VariantReferenceResolver.isProductReference(referenceValue)) {
            return this.getResolvedIdFromKeyInReference(referenceValue).thenApply(productIdOptional -> productIdOptional.map(this::createProductReferenceJson).orElse(referenceValue));
        }
        return CompletableFuture.completedFuture(referenceValue);
    }

    static boolean isProductReference(@Nonnull JsonNode referenceValue) {
        return VariantReferenceResolver.getReferenceTypeIdIfReference(referenceValue).map(referenceTypeId -> Objects.equals(referenceTypeId, Product.referenceTypeId())).orElse(false);
    }

    @Nonnull
    private static Optional<String> getReferenceTypeIdIfReference(@Nonnull JsonNode referenceValue) {
        JsonNode typeId = referenceValue.get(REFERENCE_TYPE_ID_FIELD);
        return Optional.ofNullable(typeId).map(JsonNode::asText);
    }

    @Nonnull
    CompletionStage<Optional<String>> getResolvedIdFromKeyInReference(@Nonnull JsonNode referenceValue) {
        JsonNode idField = referenceValue.get(REFERENCE_ID_FIELD);
        return idField != null ? this.productService.getIdFromCacheOrFetch(idField.asText()) : CompletableFuture.completedFuture(Optional.empty());
    }

    @Nonnull
    private JsonNode createProductReferenceJson(@Nonnull String productId) {
        ObjectNode productReferenceJsonNode = JsonNodeFactory.instance.objectNode();
        productReferenceJsonNode.put(REFERENCE_ID_FIELD, productId);
        productReferenceJsonNode.put(REFERENCE_TYPE_ID_FIELD, Product.referenceTypeId());
        return productReferenceJsonNode;
    }
}

