/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes;

import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.exceptions.InvalidReferenceException;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.producttypes.ProductTypeSyncOptions;
import com.commercetools.sync.producttypes.helpers.AttributeDefinitionReferenceResolver;
import com.commercetools.sync.producttypes.helpers.ProductTypeBatchProcessor;
import com.commercetools.sync.producttypes.helpers.ProductTypeReferenceResolver;
import com.commercetools.sync.producttypes.helpers.ProductTypeSyncStatistics;
import com.commercetools.sync.producttypes.utils.ProductTypeSyncUtils;
import com.commercetools.sync.services.ProductTypeService;
import com.commercetools.sync.services.impl.ProductTypeServiceImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraft;
import io.sphere.sdk.products.attributes.AttributeType;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.producttypes.ProductTypeDraft;
import io.sphere.sdk.producttypes.ProductTypeDraftBuilder;
import io.sphere.sdk.producttypes.ProductTypeDraftDsl;
import io.sphere.sdk.producttypes.commands.updateactions.AddAttributeDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ProductTypeSync
extends BaseSync<ProductTypeDraft, ProductTypeSyncStatistics, ProductTypeSyncOptions> {
    private static final String CTP_PRODUCT_TYPE_FETCH_FAILED = "Failed to fetch existing product types with keys: '%s'.";
    private static final String CTP_PRODUCT_TYPE_UPDATE_FAILED = "Failed to update product type with key: '%s'. Reason: %s";
    private static final String FAILED_TO_RESOLVE_REFERENCES = "Failed to resolve references on productTypeDraft with key:'%s'. Reason: %s";
    private final ProductTypeService productTypeService;
    private final ProductTypeReferenceResolver referenceResolver;
    private ConcurrentHashMap.KeySetView<String, Boolean> readyToResolve;

    public ProductTypeSync(@Nonnull ProductTypeSyncOptions productTypeSyncOptions) {
        this(productTypeSyncOptions, new ProductTypeServiceImpl(productTypeSyncOptions));
    }

    ProductTypeSync(@Nonnull ProductTypeSyncOptions productTypeSyncOptions, @Nonnull ProductTypeService productTypeService) {
        super(new ProductTypeSyncStatistics(), productTypeSyncOptions);
        this.productTypeService = productTypeService;
        this.referenceResolver = new ProductTypeReferenceResolver(productTypeSyncOptions, productTypeService);
    }

    @Override
    protected CompletionStage<ProductTypeSyncStatistics> process(@Nonnull List<ProductTypeDraft> productTypeDrafts) {
        List batches = SyncUtils.batchElements(productTypeDrafts, ((ProductTypeSyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture(this.statistics));
    }

    @Override
    protected CompletionStage<ProductTypeSyncStatistics> processBatch(@Nonnull List<ProductTypeDraft> batch) {
        this.readyToResolve = ConcurrentHashMap.newKeySet();
        ProductTypeBatchProcessor batchProcessor = new ProductTypeBatchProcessor(batch, this);
        batchProcessor.validateBatch();
        Set<String> keysToCache = batchProcessor.getKeysToCache();
        return this.productTypeService.cacheKeysToIds(keysToCache).handle(ImmutablePair::new).thenCompose(cachingResponse -> {
            Map keyToIdCache = (Map)cachingResponse.getKey();
            Throwable cachingException = (Throwable)cachingResponse.getValue();
            if (cachingException != null) {
                this.handleError("Failed to build a cache of keys to ids.", cachingException, keysToCache.size());
                return CompletableFuture.completedFuture(null);
            }
            Set<String> batchDraftKeys = batchProcessor.getValidDrafts().stream().map(ProductTypeDraft::getKey).collect(Collectors.toSet());
            return this.productTypeService.fetchMatchingProductTypesByKeys(batchDraftKeys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
                Set matchingProductTypes = (Set)fetchResponse.getKey();
                Throwable exception = (Throwable)fetchResponse.getValue();
                if (exception != null) {
                    String errorMessage = String.format(CTP_PRODUCT_TYPE_FETCH_FAILED, batchDraftKeys);
                    this.handleError(errorMessage, exception, batchDraftKeys.size());
                    return CompletableFuture.completedFuture(null);
                }
                return this.syncBatch(matchingProductTypes, batchProcessor.getValidDrafts(), keyToIdCache).thenApply(ignoredResult -> this.buildProductTypesToUpdateMap()).thenCompose(this::resolveMissingNestedReferences);
            });
        }).thenApply(ignored -> {
            ((ProductTypeSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (ProductTypeSyncStatistics)this.statistics;
        });
    }

    private void handleError(@Nonnull String errorMessage, @Nullable Throwable exception, int failedTimes) {
        ((ProductTypeSyncOptions)this.syncOptions).applyErrorCallback(errorMessage, exception);
        ((ProductTypeSyncStatistics)this.statistics).incrementFailed(failedTimes);
    }

    @Nonnull
    private CompletionStage<Void> syncBatch(@Nonnull Set<ProductType> oldProductTypes, @Nonnull Set<ProductTypeDraft> newProductTypes, @Nonnull Map<String, String> keyToIdCache) {
        Map oldProductTypeMap = oldProductTypes.stream().collect(Collectors.toMap(ProductType::getKey, Function.identity()));
        return CompletableFuture.allOf((CompletableFuture[])newProductTypes.stream().map(newProductType -> this.removeAndKeepTrackOfMissingNestedAttributes((ProductTypeDraft)newProductType, keyToIdCache)).map(draftWithoutMissingRefAttrs -> this.referenceResolver.resolveReferences((ProductTypeDraft)draftWithoutMissingRefAttrs).thenCompose(resolvedDraft -> this.syncDraft(oldProductTypeMap, (ProductTypeDraft)resolvedDraft)).exceptionally(completionException -> {
            ReferenceResolutionException referenceResolutionException = (ReferenceResolutionException)completionException.getCause();
            String errorMessage = String.format(FAILED_TO_RESOLVE_REFERENCES, draftWithoutMissingRefAttrs.getKey(), referenceResolutionException.getMessage());
            this.handleError(errorMessage, referenceResolutionException, 1);
            return null;
        })).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    @Nonnull
    private ProductTypeDraft removeAndKeepTrackOfMissingNestedAttributes(@Nonnull ProductTypeDraft productTypeDraft, @Nonnull Map<String, String> keyToIdCache) {
        ((ProductTypeSyncStatistics)this.statistics).removeReferencingProductTypeKey(productTypeDraft.getKey());
        List attributeDefinitionDrafts = productTypeDraft.getAttributes();
        if (attributeDefinitionDrafts == null || attributeDefinitionDrafts.isEmpty()) {
            return productTypeDraft;
        }
        ProductTypeDraftDsl draftCopy = ProductTypeDraftBuilder.of((ProductTypeDraft)productTypeDraft).attributes(new ArrayList(productTypeDraft.getAttributes())).build();
        for (AttributeDefinitionDraft attributeDefinitionDraft : attributeDefinitionDrafts) {
            if (attributeDefinitionDraft == null) continue;
            this.removeAndKeepTrackOfMissingNestedAttribute(attributeDefinitionDraft, (ProductTypeDraft)draftCopy, keyToIdCache);
        }
        return draftCopy;
    }

    private void removeAndKeepTrackOfMissingNestedAttribute(@Nonnull AttributeDefinitionDraft attributeDefinitionDraft, @Nonnull ProductTypeDraft productTypeDraft, @Nonnull Map<String, String> keyToIdCache) {
        AttributeType attributeType = attributeDefinitionDraft.getAttributeType();
        try {
            ProductTypeBatchProcessor.getProductTypeKey(attributeType).ifPresent(key -> {
                if (!keyToIdCache.keySet().contains(key)) {
                    productTypeDraft.getAttributes().remove(attributeDefinitionDraft);
                    ((ProductTypeSyncStatistics)this.statistics).putMissingNestedProductType((String)key, productTypeDraft.getKey(), attributeDefinitionDraft);
                }
            });
        }
        catch (InvalidReferenceException invalidReferenceException) {
            this.handleError("This exception is unexpectedly thrown since the draft batch has beenalready validated for blank keys at an earlier stage, which means this draft should have a valid reference. Please communicate this error with the maintainer of the library.", invalidReferenceException, 1);
        }
    }

    @Nonnull
    private CompletionStage<Void> syncDraft(@Nonnull Map<String, ProductType> oldProductTypeMap, @Nonnull ProductTypeDraft newProductTypeDraft) {
        ProductType oldProductType = oldProductTypeMap.get(newProductTypeDraft.getKey());
        return Optional.ofNullable(oldProductType).map(productType -> this.buildActionsAndUpdate(oldProductType, newProductTypeDraft)).orElseGet(() -> this.applyCallbackAndCreate(newProductTypeDraft));
    }

    @Nonnull
    private Map<String, Set<AttributeDefinitionDraft>> buildProductTypesToUpdateMap() {
        HashMap<String, Set<AttributeDefinitionDraft>> productTypesToUpdate = new HashMap<String, Set<AttributeDefinitionDraft>>();
        this.readyToResolve.forEach(readyToResolveProductTypeKey -> {
            ConcurrentHashMap<String, ConcurrentHashMap.KeySetView<AttributeDefinitionDraft, Boolean>> referencingProductTypes = ((ProductTypeSyncStatistics)this.statistics).getProductTypeKeysWithMissingParents().get(readyToResolveProductTypeKey);
            if (referencingProductTypes != null) {
                referencingProductTypes.forEach((productTypeKey, attributes) -> {
                    Set attributeDefinitionsToAdd = (Set)productTypesToUpdate.get(productTypeKey);
                    if (attributeDefinitionsToAdd != null) {
                        attributeDefinitionsToAdd.addAll(attributes);
                    } else {
                        productTypesToUpdate.put((String)productTypeKey, (Set<AttributeDefinitionDraft>)attributes);
                    }
                });
            }
        });
        return productTypesToUpdate;
    }

    @Nonnull
    private CompletionStage<Void> resolveMissingNestedReferences(@Nonnull Map<String, Set<AttributeDefinitionDraft>> productTypesToUpdate) {
        Set<String> keys = productTypesToUpdate.keySet();
        return this.productTypeService.fetchMatchingProductTypesByKeys(keys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Set matchingProductTypes = (Set)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_PRODUCT_TYPE_FETCH_FAILED, keys);
                this.handleError(errorMessage, exception, keys.size());
                return CompletableFuture.completedFuture(null);
            }
            Map<String, ProductType> keyToProductType = matchingProductTypes.stream().collect(Collectors.toMap(ProductType::getKey, productType -> productType));
            return CompletableFuture.allOf((CompletableFuture[])productTypesToUpdate.entrySet().stream().map(entry -> {
                String productTypeToUpdateKey = (String)entry.getKey();
                Set attributeDefinitionDrafts = (Set)entry.getValue();
                List<UpdateAction<ProductType>> actionsWithResolvedReferences = this.draftsToActions(attributeDefinitionDrafts);
                ProductType productTypeToUpdate = (ProductType)keyToProductType.get(productTypeToUpdateKey);
                return this.resolveMissingNestedReferences(productTypeToUpdate, actionsWithResolvedReferences);
            }).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
        });
    }

    @Nonnull
    private CompletionStage<Void> resolveMissingNestedReferences(@Nonnull ProductType oldProductType, @Nonnull List<UpdateAction<ProductType>> updateActions) {
        return this.productTypeService.updateProductType(oldProductType, updateActions).handle(ImmutablePair::new).thenCompose(updateResponse -> {
            Throwable sphereException = (Throwable)updateResponse.getValue();
            if (sphereException != null) {
                return ProductTypeSync.executeSupplierIfConcurrentModificationException(sphereException, () -> this.fetchAndUpdate(oldProductType, fetchedProductType -> this.resolveMissingNestedReferences((ProductType)fetchedProductType, updateActions)), () -> {
                    String errorMessage = String.format(CTP_PRODUCT_TYPE_UPDATE_FAILED, oldProductType.getKey(), sphereException.getMessage());
                    this.handleError(errorMessage, sphereException, 1);
                    return CompletableFuture.completedFuture(null);
                });
            }
            ((ProductTypeSyncStatistics)this.statistics).removeReferencingProductTypeKey(oldProductType.getKey());
            return CompletableFuture.completedFuture(null);
        });
    }

    @Nonnull
    private List<UpdateAction<ProductType>> draftsToActions(@Nonnull Set<AttributeDefinitionDraft> attributeDefinitionDrafts) {
        return attributeDefinitionDrafts.stream().map(attributeDefinitionDraft -> {
            AttributeDefinitionReferenceResolver attributeDefinitionReferenceResolver = new AttributeDefinitionReferenceResolver((ProductTypeSyncOptions)this.syncOptions, this.productTypeService);
            AttributeDefinitionDraft resolvedDraft = attributeDefinitionReferenceResolver.resolveReferences((AttributeDefinitionDraft)attributeDefinitionDraft).toCompletableFuture().join();
            return AddAttributeDefinition.of((AttributeDefinitionDraft)resolvedDraft);
        }).collect(Collectors.toList());
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Void> buildActionsAndUpdate(@Nonnull ProductType oldProductType, @Nonnull ProductTypeDraft newProductType) {
        List updateActions = ProductTypeSyncUtils.buildActions(oldProductType, newProductType, (ProductTypeSyncOptions)this.syncOptions);
        List<UpdateAction<ProductType>> updateActionsAfterCallback = ((ProductTypeSyncOptions)this.syncOptions).applyBeforeUpdateCallBack(updateActions, newProductType, oldProductType);
        if (!updateActionsAfterCallback.isEmpty()) {
            return this.updateProductType(oldProductType, newProductType, updateActionsAfterCallback);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    private CompletionStage<Void> updateProductType(@Nonnull ProductType oldProductType, @Nonnull ProductTypeDraft newProductType, @Nonnull List<UpdateAction<ProductType>> updateActions) {
        return this.productTypeService.updateProductType(oldProductType, updateActions).handle(ImmutablePair::new).thenCompose(updateResponse -> {
            Throwable sphereException = (Throwable)updateResponse.getValue();
            if (sphereException != null) {
                return ProductTypeSync.executeSupplierIfConcurrentModificationException(sphereException, () -> this.fetchAndUpdate(oldProductType, fetchedProductType -> this.buildActionsAndUpdate((ProductType)fetchedProductType, newProductType)), () -> {
                    String errorMessage = String.format(CTP_PRODUCT_TYPE_UPDATE_FAILED, newProductType.getKey(), sphereException.getMessage());
                    this.handleError(errorMessage, sphereException, 1);
                    return CompletableFuture.completedFuture(null);
                });
            }
            ((ProductTypeSyncStatistics)this.statistics).incrementUpdated();
            return CompletableFuture.completedFuture(null);
        });
    }

    @Nonnull
    private CompletionStage<Void> fetchAndUpdate(@Nonnull ProductType oldProductType, @Nonnull Function<ProductType, CompletionStage<Void>> fetchedProductMapper) {
        String key = oldProductType.getKey();
        return this.productTypeService.fetchProductType(key).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Optional fetchedProductTypeOptional = (Optional)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_PRODUCT_TYPE_UPDATE_FAILED, key, "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(errorMessage, exception, 1);
                return CompletableFuture.completedFuture(null);
            }
            return fetchedProductTypeOptional.map(fetchedProductMapper).orElseGet(() -> {
                String errorMessage = String.format(CTP_PRODUCT_TYPE_UPDATE_FAILED, key, "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(errorMessage, null, 1);
                return CompletableFuture.completedFuture(null);
            });
        });
    }

    @Nonnull
    private CompletionStage<Void> applyCallbackAndCreate(@Nonnull ProductTypeDraft productTypeDraft) {
        return ((ProductTypeSyncOptions)this.syncOptions).applyBeforeCreateCallBack(productTypeDraft).map(draft -> this.productTypeService.createProductType((ProductTypeDraft)draft).thenAccept(productTypeOptional -> {
            if (productTypeOptional.isPresent()) {
                this.readyToResolve.add(productTypeDraft.getKey());
                ((ProductTypeSyncStatistics)this.statistics).incrementCreated();
            } else {
                ((ProductTypeSyncStatistics)this.statistics).incrementFailed();
            }
        })).orElseGet(() -> CompletableFuture.completedFuture(null));
    }
}

