/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.helpers;

import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.BaseReferenceResolver;
import com.commercetools.sync.producttypes.ProductTypeSyncOptions;
import com.commercetools.sync.services.ProductTypeService;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraft;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraftBuilder;
import io.sphere.sdk.products.attributes.AttributeType;
import io.sphere.sdk.products.attributes.NestedAttributeType;
import io.sphere.sdk.products.attributes.SetAttributeType;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.utils.CompletableFutureUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class AttributeDefinitionReferenceResolver
extends BaseReferenceResolver<AttributeDefinitionDraft, ProductTypeSyncOptions> {
    private ProductTypeService productTypeService;

    public AttributeDefinitionReferenceResolver(@Nonnull ProductTypeSyncOptions options, @Nonnull ProductTypeService productTypeService) {
        super(options);
        this.productTypeService = productTypeService;
    }

    @Override
    @Nonnull
    public CompletionStage<AttributeDefinitionDraft> resolveReferences(@Nonnull AttributeDefinitionDraft attributeDefinitionDraft) {
        AttributeDefinitionDraftBuilder draftBuilder = AttributeDefinitionDraftBuilder.of((AttributeDefinitionDraft)attributeDefinitionDraft);
        return this.resolveReferences(draftBuilder).handle(ImmutablePair::new).thenCompose(result -> {
            Throwable exception = (Throwable)result.getValue();
            AttributeDefinitionDraftBuilder resolvedBuilder = (AttributeDefinitionDraftBuilder)result.getKey();
            if (exception == null) {
                return CompletableFuture.completedFuture(resolvedBuilder.build());
            }
            String errorMessage = String.format("Failed to resolve references on attribute definition with name '%s'.", attributeDefinitionDraft.getName());
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(errorMessage, exception.getCause()));
        });
    }

    @Override
    @Nonnull
    private CompletionStage<AttributeDefinitionDraftBuilder> resolveReferences(@Nonnull AttributeDefinitionDraftBuilder attributeDefinitionDraftBuilder) {
        SetAttributeType setAttributeType;
        AttributeType elementType;
        AttributeType attributeType = attributeDefinitionDraftBuilder.getAttributeType();
        if (attributeType instanceof NestedAttributeType) {
            return this.resolveNestedTypeReference((NestedAttributeType)attributeType).thenApply(x$0 -> (AttributeDefinitionDraftBuilder)attributeDefinitionDraftBuilder.attributeType(x$0));
        }
        if (attributeType instanceof SetAttributeType && (elementType = (setAttributeType = (SetAttributeType)attributeType).getElementType()) instanceof NestedAttributeType) {
            return this.resolveNestedTypeReference((NestedAttributeType)elementType).thenApply(SetAttributeType::of).thenApply(x$0 -> (AttributeDefinitionDraftBuilder)attributeDefinitionDraftBuilder.attributeType(x$0));
        }
        return CompletableFuture.completedFuture(attributeDefinitionDraftBuilder);
    }

    @Nonnull
    private CompletionStage<NestedAttributeType> resolveNestedTypeReference(@Nonnull NestedAttributeType nestedAttributeType) {
        Reference typeReference = nestedAttributeType.getTypeReference();
        return this.resolveProductTypeReference((Reference<ProductType>)typeReference).thenApply(optionalResolvedReference -> optionalResolvedReference.map(NestedAttributeType::of).orElse(nestedAttributeType));
    }

    @Nonnull
    private CompletionStage<Optional<Reference<ProductType>>> resolveProductTypeReference(@Nonnull Reference<ProductType> typeReference) {
        String resourceKey;
        try {
            resourceKey = AttributeDefinitionReferenceResolver.getKeyFromResourceIdentifier(typeReference);
        }
        catch (ReferenceResolutionException exception) {
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException("Failed to resolve NestedType productType reference.", exception));
        }
        return this.productTypeService.fetchCachedProductTypeId(resourceKey).thenApply(optionalId -> optionalId.map(ProductType::referenceOfId));
    }
}

