/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.helpers;

import com.commercetools.sync.commons.exceptions.InvalidProductTypeDraftException;
import com.commercetools.sync.commons.exceptions.InvalidReferenceException;
import com.commercetools.sync.producttypes.ProductTypeSync;
import com.commercetools.sync.producttypes.ProductTypeSyncOptions;
import com.commercetools.sync.producttypes.helpers.ProductTypeSyncStatistics;
import io.sphere.sdk.products.attributes.AttributeDefinitionDraft;
import io.sphere.sdk.products.attributes.AttributeType;
import io.sphere.sdk.products.attributes.NestedAttributeType;
import io.sphere.sdk.products.attributes.SetAttributeType;
import io.sphere.sdk.producttypes.ProductTypeDraft;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class ProductTypeBatchProcessor {
    static final String PRODUCT_TYPE_DRAFT_KEY_NOT_SET = "ProductTypeDraft with name: %s doesn't have a key. Please make sure all productType drafts have keys.";
    static final String PRODUCT_TYPE_DRAFT_IS_NULL = "ProductTypeDraft is null.";
    static final String PRODUCT_TYPE_HAS_INVALID_REFERENCES = "ProductTypeDraft with key: '%s' has invalid productType references on the following AttributeDefinitionDrafts: %s";
    private final List<ProductTypeDraft> productTypeDrafts;
    private final ProductTypeSync productTypeSync;
    private final Set<ProductTypeDraft> validDrafts = new HashSet<ProductTypeDraft>();
    private final Set<String> keysToCache = new HashSet<String>();

    public ProductTypeBatchProcessor(@Nonnull List<ProductTypeDraft> productTypeDrafts, @Nonnull ProductTypeSync productTypeSync) {
        this.productTypeDrafts = productTypeDrafts;
        this.productTypeSync = productTypeSync;
    }

    public void validateBatch() {
        for (ProductTypeDraft productTypeDraft : this.productTypeDrafts) {
            if (productTypeDraft != null) {
                String productTypeDraftKey = productTypeDraft.getKey();
                if (StringUtils.isNotBlank((CharSequence)productTypeDraftKey)) {
                    try {
                        Set<String> referencedProductTypeKeys = ProductTypeBatchProcessor.getReferencedProductTypeKeys(productTypeDraft);
                        this.keysToCache.addAll(referencedProductTypeKeys);
                        this.validDrafts.add(productTypeDraft);
                    }
                    catch (InvalidProductTypeDraftException invalidProductTypeDraftException) {
                        this.handleError(invalidProductTypeDraftException);
                    }
                    continue;
                }
                String errorMessage = String.format(PRODUCT_TYPE_DRAFT_KEY_NOT_SET, productTypeDraft.getName());
                this.handleError(new InvalidProductTypeDraftException(errorMessage));
                continue;
            }
            this.handleError(new InvalidProductTypeDraftException(PRODUCT_TYPE_DRAFT_IS_NULL));
        }
    }

    @Nonnull
    private static Set<String> getReferencedProductTypeKeys(@Nonnull ProductTypeDraft productTypeDraft) throws InvalidProductTypeDraftException {
        List attributeDefinitionDrafts = productTypeDraft.getAttributes();
        if (attributeDefinitionDrafts == null || attributeDefinitionDrafts.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> referencedProductTypeKeys = new HashSet<String>();
        ArrayList<String> invalidAttributeDefinitionNames = new ArrayList<String>();
        for (AttributeDefinitionDraft attributeDefinitionDraft : attributeDefinitionDrafts) {
            if (attributeDefinitionDraft == null) continue;
            AttributeType attributeType = attributeDefinitionDraft.getAttributeType();
            try {
                ProductTypeBatchProcessor.getProductTypeKey(attributeType).ifPresent(referencedProductTypeKeys::add);
            }
            catch (InvalidReferenceException invalidReferenceException) {
                invalidAttributeDefinitionNames.add(attributeDefinitionDraft.getName());
            }
        }
        if (!invalidAttributeDefinitionNames.isEmpty()) {
            String errorMessage = String.format(PRODUCT_TYPE_HAS_INVALID_REFERENCES, productTypeDraft.getKey(), invalidAttributeDefinitionNames);
            throw new InvalidProductTypeDraftException(errorMessage, new InvalidReferenceException("The value of the 'id' field of the Resource Identifier/Reference is blank (null/empty)."));
        }
        return referencedProductTypeKeys;
    }

    @Nonnull
    public static Optional<String> getProductTypeKey(@Nonnull AttributeType attributeType) throws InvalidReferenceException {
        if (attributeType instanceof NestedAttributeType) {
            NestedAttributeType nestedElementType = (NestedAttributeType)attributeType;
            return Optional.of(ProductTypeBatchProcessor.getProductTypeKey(nestedElementType));
        }
        if (attributeType instanceof SetAttributeType) {
            SetAttributeType setAttributeType = (SetAttributeType)attributeType;
            return ProductTypeBatchProcessor.getProductTypeKey(setAttributeType.getElementType());
        }
        return Optional.empty();
    }

    @Nonnull
    private static String getProductTypeKey(@Nonnull NestedAttributeType nestedAttributeType) throws InvalidReferenceException {
        String key = nestedAttributeType.getTypeReference().getId();
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new InvalidReferenceException("The value of the 'id' field of the Resource Identifier/Reference is blank (null/empty).");
        }
        return key;
    }

    private void handleError(@Nonnull Throwable throwable) {
        ((ProductTypeSyncOptions)this.productTypeSync.getSyncOptions()).applyErrorCallback(throwable.getMessage(), throwable);
        ((ProductTypeSyncStatistics)this.productTypeSync.getStatistics()).incrementFailed();
    }

    public Set<ProductTypeDraft> getValidDrafts() {
        return this.validDrafts;
    }

    public Set<String> getKeysToCache() {
        return this.keysToCache;
    }
}

