/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.utils.CtpQueryUtils;
import com.commercetools.sync.services.ChannelService;
import io.sphere.sdk.channels.Channel;
import io.sphere.sdk.channels.ChannelDraft;
import io.sphere.sdk.channels.ChannelDraftBuilder;
import io.sphere.sdk.channels.ChannelDraftDsl;
import io.sphere.sdk.channels.ChannelRole;
import io.sphere.sdk.channels.commands.ChannelCreateCommand;
import io.sphere.sdk.channels.queries.ChannelQuery;
import io.sphere.sdk.channels.queries.ChannelQueryBuilder;
import io.sphere.sdk.client.SphereRequest;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public final class ChannelServiceImpl
implements ChannelService {
    private final BaseSyncOptions syncOptions;
    private final Set<ChannelRole> channelRoles;
    private final Map<String, String> keyToIdCache = new ConcurrentHashMap<String, String>();
    private boolean isCached = false;

    public ChannelServiceImpl(@Nonnull BaseSyncOptions syncOptions, @Nonnull Set<ChannelRole> channelRoles) {
        this.syncOptions = syncOptions;
        this.channelRoles = channelRoles;
    }

    public ChannelServiceImpl(@Nonnull BaseSyncOptions syncOptions) {
        this.syncOptions = syncOptions;
        this.channelRoles = Collections.emptySet();
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedChannelId(@Nonnull String key) {
        if (!this.isCached) {
            return this.fetchAndCache(key);
        }
        return CompletableFuture.completedFuture(Optional.ofNullable(this.keyToIdCache.get(key)));
    }

    private CompletionStage<Optional<String>> fetchAndCache(@Nonnull String key) {
        ChannelQueryBuilder channelQueryBuilder = ChannelQueryBuilder.of();
        if (!this.channelRoles.isEmpty()) {
            channelQueryBuilder = channelQueryBuilder.plusPredicates(channelQueryModel -> channelQueryModel.roles().containsAny(this.channelRoles));
        }
        ChannelQuery query = channelQueryBuilder.build();
        Consumer channelPageConsumer = channelsPage -> channelsPage.forEach(channel -> this.keyToIdCache.put(channel.getKey(), channel.getId()));
        return CtpQueryUtils.queryAll(this.syncOptions.getCtpClient(), query, channelPageConsumer).thenAccept(result -> {
            this.isCached = true;
        }).thenApply(result -> Optional.ofNullable(this.keyToIdCache.get(key)));
    }

    @Override
    @Nonnull
    public CompletionStage<Channel> createChannel(@Nonnull String key) {
        ChannelDraftDsl draft = ChannelDraftBuilder.of((String)key).roles(this.channelRoles).build();
        return this.syncOptions.getCtpClient().execute((SphereRequest)ChannelCreateCommand.of((ChannelDraft)draft));
    }

    @Override
    @Nonnull
    public CompletionStage<Channel> createAndCacheChannel(@Nonnull String key) {
        return this.createChannel(key).thenApply(channel -> {
            this.cacheChannel((Channel)channel);
            return channel;
        });
    }

    @Override
    public void cacheChannel(@Nonnull Channel channel) {
        this.keyToIdCache.put(channel.getKey(), channel.getId());
    }
}

