/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.services.InventoryService;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import io.sphere.sdk.inventory.commands.InventoryEntryCreateCommand;
import io.sphere.sdk.inventory.commands.InventoryEntryUpdateCommand;
import io.sphere.sdk.inventory.queries.InventoryEntryQuery;
import io.sphere.sdk.inventory.queries.InventoryEntryQueryBuilder;
import io.sphere.sdk.models.Versioned;
import io.sphere.sdk.queries.QueryDsl;
import io.sphere.sdk.queries.QueryExecutionUtils;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public final class InventoryServiceImpl
implements InventoryService {
    private final SphereClient ctpClient;

    public InventoryServiceImpl(@Nonnull SphereClient ctpClient) {
        this.ctpClient = ctpClient;
    }

    @Override
    @Nonnull
    public CompletionStage<List<InventoryEntry>> fetchInventoryEntriesBySkus(@Nonnull Set<String> skus) {
        InventoryEntryQuery query = InventoryEntryQueryBuilder.of().plusPredicates(queryModel -> queryModel.sku().isIn((Iterable)skus)).build();
        return QueryExecutionUtils.queryAll((SphereClient)this.ctpClient, (QueryDsl)query);
    }

    @Override
    @Nonnull
    public CompletionStage<InventoryEntry> createInventoryEntry(@Nonnull InventoryEntryDraft inventoryEntryDraft) {
        return this.ctpClient.execute((SphereRequest)InventoryEntryCreateCommand.of((InventoryEntryDraft)inventoryEntryDraft));
    }

    @Override
    @Nonnull
    public CompletionStage<InventoryEntry> updateInventoryEntry(@Nonnull InventoryEntry inventoryEntry, @Nonnull List<UpdateAction<InventoryEntry>> updateActions) {
        return this.ctpClient.execute((SphereRequest)InventoryEntryUpdateCommand.of((Versioned)inventoryEntry, updateActions));
    }
}

