/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.utils.CtpQueryUtils;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.services.ProductService;
import com.commercetools.sync.services.impl.BaseService;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.commands.ProductCreateCommand;
import io.sphere.sdk.products.commands.ProductUpdateCommand;
import io.sphere.sdk.products.queries.ProductQuery;
import io.sphere.sdk.queries.QueryPredicate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class ProductServiceImpl
extends BaseService<ProductDraft, Product, ProductSyncOptions>
implements ProductService {
    public ProductServiceImpl(@Nonnull ProductSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> getIdFromCacheOrFetch(@Nullable String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (this.keyToIdCache.containsKey(key)) {
            return CompletableFuture.completedFuture(Optional.of(this.keyToIdCache.get(key)));
        }
        return this.fetchAndCache(key);
    }

    @Nonnull
    private CompletionStage<Optional<String>> fetchAndCache(@Nonnull String key) {
        return this.cacheKeysToIds(Collections.singleton(key)).thenApply(result -> Optional.ofNullable(this.keyToIdCache.get(key)));
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> productKeys) {
        Set<String> keysNotCached = productKeys.stream().filter(StringUtils::isNotBlank).filter(key -> !this.keyToIdCache.containsKey(key)).collect(Collectors.toSet());
        if (keysNotCached.isEmpty()) {
            return CompletableFuture.completedFuture(this.keyToIdCache);
        }
        ProductQuery productQuery = (ProductQuery)ProductQuery.of().withPredicates(this.buildProductKeysQueryPredicate(keysNotCached));
        return CtpQueryUtils.queryAll(((ProductSyncOptions)this.syncOptions).getCtpClient(), productQuery, this::cacheProductIds).thenApply(result -> this.keyToIdCache);
    }

    private void cacheProductIds(@Nonnull List<Product> products) {
        products.forEach(product -> this.keyToIdCache.put(product.getKey(), product.getId()));
    }

    QueryPredicate<Product> buildProductKeysQueryPredicate(@Nonnull Set<String> productKeys) {
        List keysSurroundedWithDoubleQuotes = productKeys.stream().filter(StringUtils::isNotBlank).map(productKey -> String.format("\"%s\"", productKey)).collect(Collectors.toList());
        String keysQueryString = keysSurroundedWithDoubleQuotes.toString();
        keysQueryString = keysQueryString.substring(1, keysQueryString.length() - 1);
        return QueryPredicate.of((String)String.format("key in (%s)", keysQueryString));
    }

    @Override
    @Nonnull
    public CompletionStage<Set<Product>> fetchMatchingProductsByKeys(@Nonnull Set<String> productKeys) {
        if (productKeys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptySet());
        }
        ProductQuery productQuery = (ProductQuery)ProductQuery.of().withPredicates(this.buildProductKeysQueryPredicate(productKeys));
        return CtpQueryUtils.queryAll(((ProductSyncOptions)this.syncOptions).getCtpClient(), productQuery, Function.identity()).thenApply(fetchedProducts -> fetchedProducts.stream().flatMap(Collection::stream).peek(product -> this.keyToIdCache.put(product.getKey(), product.getId())).collect(Collectors.toSet()));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Product>> fetchProduct(@Nullable String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        ProductQuery productQuery = (ProductQuery)ProductQuery.of().withPredicates(this.buildProductKeysQueryPredicate(Collections.singleton(key)));
        return ((ProductSyncOptions)this.syncOptions).getCtpClient().execute((SphereRequest)productQuery).thenApply(productPagedQueryResult -> productPagedQueryResult.head().map(product -> {
            this.keyToIdCache.put(product.getKey(), product.getId());
            return product;
        }));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Product>> createProduct(@Nonnull ProductDraft productDraft) {
        return this.createResource(productDraft, ProductDraft::getKey, ProductCreateCommand::of);
    }

    @Override
    @Nonnull
    public CompletionStage<Product> updateProduct(@Nonnull Product product, @Nonnull List<UpdateAction<Product>> updateActions) {
        return this.updateResource(product, ProductUpdateCommand::of, updateActions);
    }
}

