/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.utils.CtpQueryUtils;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.services.StateService;
import io.sphere.sdk.queries.QueryPredicate;
import io.sphere.sdk.states.StateType;
import io.sphere.sdk.states.queries.StateQuery;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class StateServiceImpl
implements StateService {
    private final ProductSyncOptions syncOptions;
    private final StateType stateType;
    private final Map<String, String> keyToIdCache = new ConcurrentHashMap<String, String>();

    public StateServiceImpl(@Nonnull ProductSyncOptions syncOptions, @Nonnull StateType stateType) {
        this.syncOptions = syncOptions;
        this.stateType = stateType;
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedStateId(@Nullable String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (this.keyToIdCache.isEmpty()) {
            return this.fetchAndCache(key);
        }
        return CompletableFuture.completedFuture(Optional.ofNullable(this.keyToIdCache.get(key)));
    }

    @Nonnull
    private CompletionStage<Optional<String>> fetchAndCache(@Nonnull String key) {
        Consumer statePageConsumer = statePage -> statePage.forEach(state -> {
            String fetchedStateKey = state.getKey();
            String id = state.getId();
            this.keyToIdCache.put(fetchedStateKey, id);
        });
        return CtpQueryUtils.queryAll(this.syncOptions.getCtpClient(), StateServiceImpl.buildStateQuery(this.stateType), statePageConsumer).thenApply(result -> Optional.ofNullable(this.keyToIdCache.get(key)));
    }

    public static StateQuery buildStateQuery(@Nonnull StateType stateType) {
        QueryPredicate stateQueryPredicate = QueryPredicate.of((String)String.format("type= \"%s\"", stateType.toSphereName()));
        return StateQuery.of().withPredicates(stateQueryPredicate);
    }
}

