/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.utils.CtpQueryUtils;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.impl.BaseService;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.types.Type;
import io.sphere.sdk.types.TypeDraft;
import io.sphere.sdk.types.commands.TypeCreateCommand;
import io.sphere.sdk.types.commands.TypeUpdateCommand;
import io.sphere.sdk.types.queries.TypeQuery;
import io.sphere.sdk.types.queries.TypeQueryBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.util.TextUtils;

public final class TypeServiceImpl
extends BaseService<TypeDraft, Type, BaseSyncOptions>
implements TypeService {
    public TypeServiceImpl(@Nonnull BaseSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedTypeId(@Nonnull String key) {
        if (this.keyToIdCache.containsKey(key)) {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.keyToIdCache.get(key)));
        }
        return this.fetchAndCache(key);
    }

    @Nonnull
    private CompletionStage<Optional<String>> fetchAndCache(@Nonnull String key) {
        Consumer typePageConsumer = typePage -> typePage.forEach(type -> this.keyToIdCache.put(type.getKey(), type.getId()));
        return CtpQueryUtils.queryAll(this.syncOptions.getCtpClient(), TypeQuery.of(), typePageConsumer).thenApply(result -> Optional.ofNullable(this.keyToIdCache.get(key)));
    }

    @Override
    @Nonnull
    public CompletionStage<Set<Type>> fetchMatchingTypesByKeys(@Nonnull Set<String> keys) {
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptySet());
        }
        TypeQuery typeQuery = TypeQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().isIn((Iterable)keys)).build();
        return CtpQueryUtils.queryAll(this.syncOptions.getCtpClient(), typeQuery, Function.identity()).thenApply(types -> types.stream().flatMap(Collection::stream).peek(type -> this.keyToIdCache.put(type.getKey(), type.getId())).collect(Collectors.toSet()));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Type>> fetchType(@Nullable String key) {
        if (TextUtils.isBlank((CharSequence)key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        TypeQuery typeQuery = TypeQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().is(key)).build();
        return this.syncOptions.getCtpClient().execute((SphereRequest)typeQuery).thenApply(typePagedQueryResult -> typePagedQueryResult.head().map(type -> {
            this.keyToIdCache.put(type.getKey(), type.getId());
            return type;
        }));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Type>> createType(@Nonnull TypeDraft typeDraft) {
        return this.createResource(typeDraft, TypeDraft::getKey, TypeCreateCommand::of);
    }

    @Override
    @Nonnull
    public CompletionStage<Type> updateType(@Nonnull Type type, @Nonnull List<UpdateAction<Type>> updateActions) {
        return this.updateResource(type, TypeUpdateCommand::of, updateActions);
    }
}

