/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.types;

import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.impl.TypeServiceImpl;
import com.commercetools.sync.types.TypeSyncOptions;
import com.commercetools.sync.types.helpers.TypeSyncStatistics;
import com.commercetools.sync.types.utils.TypeSyncUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.types.Type;
import io.sphere.sdk.types.TypeDraft;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TypeSync
extends BaseSync<TypeDraft, TypeSyncStatistics, TypeSyncOptions> {
    private static final String CTP_TYPE_FETCH_FAILED = "Failed to fetch existing types with keys: '%s'.";
    private static final String CTP_TYPE_UPDATE_FAILED = "Failed to update type with key: '%s'. Reason: %s";
    private static final String TYPE_DRAFT_HAS_NO_KEY = "Failed to process type draft without key.";
    private static final String TYPE_DRAFT_IS_NULL = "Failed to process null type draft.";
    private final TypeService typeService;

    public TypeSync(@Nonnull TypeSyncOptions typeSyncOptions) {
        this(typeSyncOptions, new TypeServiceImpl(typeSyncOptions));
    }

    TypeSync(@Nonnull TypeSyncOptions typeSyncOptions, @Nonnull TypeService typeService) {
        super(new TypeSyncStatistics(), typeSyncOptions);
        this.typeService = typeService;
    }

    @Override
    protected CompletionStage<TypeSyncStatistics> process(@Nonnull List<TypeDraft> typeDrafts) {
        List batches = SyncUtils.batchElements(typeDrafts, ((TypeSyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture(this.statistics));
    }

    @Override
    protected CompletionStage<TypeSyncStatistics> processBatch(@Nonnull List<TypeDraft> batch) {
        Set validTypeDrafts = batch.stream().filter(this::validateDraft).collect(Collectors.toSet());
        if (validTypeDrafts.isEmpty()) {
            ((TypeSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return CompletableFuture.completedFuture(this.statistics);
        }
        Set<String> keys = validTypeDrafts.stream().map(TypeDraft::getKey).collect(Collectors.toSet());
        return this.typeService.fetchMatchingTypesByKeys(keys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Set fetchedTypes = (Set)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_TYPE_FETCH_FAILED, keys);
                this.handleError(errorMessage, exception, keys.size());
                return CompletableFuture.completedFuture(null);
            }
            return this.syncBatch(fetchedTypes, validTypeDrafts);
        }).thenApply(ignored -> {
            ((TypeSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (TypeSyncStatistics)this.statistics;
        });
    }

    private boolean validateDraft(@Nullable TypeDraft draft) {
        if (draft == null) {
            this.handleError(TYPE_DRAFT_IS_NULL, null, 1);
        } else if (StringUtils.isBlank((CharSequence)draft.getKey())) {
            this.handleError(TYPE_DRAFT_HAS_NO_KEY, null, 1);
        } else {
            return true;
        }
        return false;
    }

    private void handleError(@Nonnull String errorMessage, @Nullable Throwable exception, int failedTimes) {
        ((TypeSyncOptions)this.syncOptions).applyErrorCallback(errorMessage, exception);
        ((TypeSyncStatistics)this.statistics).incrementFailed(failedTimes);
    }

    @Nonnull
    private CompletionStage<Void> syncBatch(@Nonnull Set<Type> oldTypes, @Nonnull Set<TypeDraft> newTypes) {
        Map oldTypeMap = oldTypes.stream().collect(Collectors.toMap(Type::getKey, Function.identity()));
        return CompletableFuture.allOf((CompletableFuture[])newTypes.stream().map(newType -> {
            Type oldType = (Type)oldTypeMap.get(newType.getKey());
            return Optional.ofNullable(oldType).map(type -> this.buildActionsAndUpdate(oldType, (TypeDraft)newType)).orElseGet(() -> this.applyCallbackAndCreate((TypeDraft)newType));
        }).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    @Nonnull
    private CompletionStage<Optional<Type>> applyCallbackAndCreate(@Nonnull TypeDraft typeDraft) {
        return ((TypeSyncOptions)this.syncOptions).applyBeforeCreateCallBack(typeDraft).map(draft -> this.typeService.createType((TypeDraft)draft).thenApply(typeOptional -> {
            if (typeOptional.isPresent()) {
                ((TypeSyncStatistics)this.statistics).incrementCreated();
            } else {
                ((TypeSyncStatistics)this.statistics).incrementFailed();
            }
            return typeOptional;
        })).orElse(CompletableFuture.completedFuture(Optional.empty()));
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Optional<Type>> buildActionsAndUpdate(@Nonnull Type oldType, @Nonnull TypeDraft newType) {
        List updateActions = TypeSyncUtils.buildActions(oldType, newType, (TypeSyncOptions)this.syncOptions);
        List<UpdateAction<Type>> updateActionsAfterCallback = ((TypeSyncOptions)this.syncOptions).applyBeforeUpdateCallBack(updateActions, newType, oldType);
        if (!updateActionsAfterCallback.isEmpty()) {
            return this.updateType(oldType, newType, updateActionsAfterCallback);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    private CompletionStage<Optional<Type>> updateType(@Nonnull Type oldType, @Nonnull TypeDraft newType, @Nonnull List<UpdateAction<Type>> updateActions) {
        return this.typeService.updateType(oldType, updateActions).handle(ImmutablePair::new).thenCompose(updateResponse -> {
            Type updatedType = (Type)updateResponse.getKey();
            Throwable sphereException = (Throwable)updateResponse.getValue();
            if (sphereException != null) {
                return TypeSync.executeSupplierIfConcurrentModificationException(sphereException, () -> this.fetchAndUpdate(oldType, newType), () -> {
                    String errorMessage = String.format(CTP_TYPE_UPDATE_FAILED, newType.getKey(), sphereException.getMessage());
                    this.handleError(errorMessage, sphereException, 1);
                    return CompletableFuture.completedFuture(Optional.empty());
                });
            }
            ((TypeSyncStatistics)this.statistics).incrementUpdated();
            return CompletableFuture.completedFuture(Optional.of(updatedType));
        });
    }

    @Nonnull
    private CompletionStage<Optional<Type>> fetchAndUpdate(@Nonnull Type oldType, @Nonnull TypeDraft newType) {
        String key = oldType.getKey();
        return this.typeService.fetchType(key).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Optional fetchedTypeOptional = (Optional)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_TYPE_UPDATE_FAILED, key, "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(errorMessage, exception, 1);
                return CompletableFuture.completedFuture(null);
            }
            return fetchedTypeOptional.map(fetchedType -> this.buildActionsAndUpdate((Type)fetchedType, newType)).orElseGet(() -> {
                String errorMessage = String.format(CTP_TYPE_UPDATE_FAILED, key, "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(errorMessage, null, 1);
                return CompletableFuture.completedFuture(null);
            });
        });
    }
}

