/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.helpers;

import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.AssetReferenceResolver;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import com.commercetools.sync.services.CategoryService;
import com.commercetools.sync.services.TypeService;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.categories.CategoryDraft;
import io.sphere.sdk.categories.CategoryDraftBuilder;
import io.sphere.sdk.models.ResourceIdentifier;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CategoryReferenceResolver
extends CustomReferenceResolver<CategoryDraft, CategoryDraftBuilder, CategorySyncOptions> {
    private final AssetReferenceResolver assetReferenceResolver;
    private CategoryService categoryService;
    private static final String FAILED_TO_RESOLVE_PARENT = "Failed to resolve parent reference on CategoryDraft with key:'%s'. Reason: %s";
    private static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on CategoryDraft with key:'%s'.";

    public CategoryReferenceResolver(@Nonnull CategorySyncOptions options, @Nonnull TypeService typeService, @Nonnull CategoryService categoryService) {
        super(options, typeService);
        this.assetReferenceResolver = new AssetReferenceResolver(options, typeService);
        this.categoryService = categoryService;
    }

    @Override
    @Nonnull
    public CompletionStage<CategoryDraft> resolveReferences(@Nonnull CategoryDraft categoryDraft) {
        return this.resolveCustomTypeReference(CategoryDraftBuilder.of((CategoryDraft)categoryDraft)).thenCompose(this::resolveParentReference).thenCompose(this::resolveAssetsReferences).thenApply(rec$ -> ((CategoryDraftBuilder)rec$).build());
    }

    @Nonnull
    CompletionStage<CategoryDraftBuilder> resolveAssetsReferences(@Nonnull CategoryDraftBuilder categoryDraftBuilder) {
        List categoryDraftAssets = categoryDraftBuilder.getAssets();
        if (categoryDraftAssets == null) {
            return CompletableFuture.completedFuture(categoryDraftBuilder);
        }
        return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(categoryDraftAssets, this.assetReferenceResolver::resolveReferences, Collectors.toList()).thenApply(x$0 -> (CategoryDraftBuilder)categoryDraftBuilder.assets(x$0));
    }

    @Override
    @Nonnull
    protected CompletionStage<CategoryDraftBuilder> resolveCustomTypeReference(@Nonnull CategoryDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, rec$ -> ((CategoryDraftBuilder)rec$).getCustom(), (rec$, x$0) -> (CategoryDraftBuilder)((CategoryDraftBuilder)rec$).custom(x$0), String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getKey()));
    }

    @Nonnull
    CompletionStage<CategoryDraftBuilder> resolveParentReference(@Nonnull CategoryDraftBuilder draftBuilder) {
        try {
            return CategoryReferenceResolver.getParentCategoryKey(draftBuilder).map(parentCategoryKey -> this.fetchAndResolveParentReference(draftBuilder, (String)parentCategoryKey)).orElseGet(() -> CompletableFuture.completedFuture(draftBuilder));
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            return io.sphere.sdk.utils.CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)referenceResolutionException);
        }
    }

    @Nonnull
    public static Optional<String> getParentCategoryKey(@Nonnull CategoryDraftBuilder draftBuilder) throws ReferenceResolutionException {
        return CategoryReferenceResolver.getParentCategoryKey((ResourceIdentifier<Category>)draftBuilder.getParent(), draftBuilder.getKey());
    }

    @Nonnull
    public static Optional<String> getParentCategoryKey(@Nonnull CategoryDraft draft) throws ReferenceResolutionException {
        return CategoryReferenceResolver.getParentCategoryKey((ResourceIdentifier<Category>)draft.getParent(), draft.getKey());
    }

    @Nonnull
    private static Optional<String> getParentCategoryKey(@Nullable ResourceIdentifier<Category> parentCategoryResourceIdentifier, @Nullable String categoryKey) throws ReferenceResolutionException {
        if (parentCategoryResourceIdentifier != null) {
            try {
                String parentKey = CategoryReferenceResolver.getKeyFromResourceIdentifier(parentCategoryResourceIdentifier);
                return Optional.of(parentKey);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                throw new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_PARENT, categoryKey, referenceResolutionException.getMessage()), referenceResolutionException);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    private CompletionStage<CategoryDraftBuilder> fetchAndResolveParentReference(@Nonnull CategoryDraftBuilder draftBuilder, @Nonnull String parentCategoryKey) {
        return this.categoryService.fetchCachedCategoryId(parentCategoryKey).thenApply(resolvedParentIdOptional -> resolvedParentIdOptional.map(resolvedParentId -> (CategoryDraftBuilder)draftBuilder.parent(Category.referenceOfId((String)resolvedParentId).toResourceIdentifier())).orElse(draftBuilder));
    }
}

