/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.ResourceIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SyncUtils {
    public static <T> List<List<T>> batchElements(@Nonnull List<T> elements, int batchSize) {
        ArrayList<List<T>> batches = new ArrayList<List<T>>();
        for (int i = 0; i < elements.size() && batchSize > 0; i += batchSize) {
            batches.add(elements.subList(i, Math.min(i + batchSize, elements.size())));
        }
        return batches;
    }

    @Nullable
    public static <T> Reference<T> getReferenceWithKeyReplaced(@Nullable Reference<T> reference, @Nonnull Supplier<Reference<T>> keyInReferenceSupplier) {
        if (reference != null && reference.getObj() != null) {
            return keyInReferenceSupplier.get();
        }
        return reference;
    }

    @Nullable
    public static <T> ResourceIdentifier<T> getResourceIdentifierWithKeyReplaced(@Nullable Reference<T> reference, @Nonnull Supplier<ResourceIdentifier<T>> keyInReferenceSupplier) {
        if (reference != null && reference.getObj() != null) {
            return keyInReferenceSupplier.get();
        }
        return reference;
    }

    private SyncUtils() {
    }
}

