/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories;

import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.inventories.InventorySyncOptions;
import com.commercetools.sync.inventories.helpers.InventoryEntryIdentifier;
import com.commercetools.sync.inventories.helpers.InventoryReferenceResolver;
import com.commercetools.sync.inventories.helpers.InventorySyncStatistics;
import com.commercetools.sync.inventories.utils.InventorySyncUtils;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.InventoryService;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.impl.ChannelServiceImpl;
import com.commercetools.sync.services.impl.InventoryServiceImpl;
import com.commercetools.sync.services.impl.TypeServiceImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sphere.sdk.channels.ChannelRole;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import io.sphere.sdk.models.ResourceIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class InventorySync
extends BaseSync<InventoryEntryDraft, InventorySyncStatistics, InventorySyncOptions> {
    private static final String CTP_INVENTORY_FETCH_FAILED = "Failed to fetch existing inventory entries of SKUs %s.";
    private static final String CTP_INVENTORY_ENTRY_UPDATE_FAILED = "Failed to update inventory entry of SKU '%s' and supply channel id '%s'.";
    private static final String INVENTORY_DRAFT_HAS_NO_SKU = "Failed to process inventory entry without SKU.";
    private static final String INVENTORY_DRAFT_IS_NULL = "Failed to process null inventory draft.";
    private static final String CTP_INVENTORY_ENTRY_CREATE_FAILED = "Failed to create inventory entry of SKU '%s' and supply channel id '%s'.";
    private static final String FAILED_TO_RESOLVE_REFERENCES = "Failed to resolve references on InventoryEntryDraft with SKU:'%s'. Reason: %s";
    private final InventoryService inventoryService;
    private final InventoryReferenceResolver referenceResolver;

    public InventorySync(@Nonnull InventorySyncOptions syncOptions) {
        this(syncOptions, new InventoryServiceImpl(syncOptions.getCtpClient()), new ChannelServiceImpl(syncOptions, Collections.singleton(ChannelRole.INVENTORY_SUPPLY)), new TypeServiceImpl(syncOptions));
    }

    InventorySync(@Nonnull InventorySyncOptions syncOptions, @Nonnull InventoryService inventoryService, @Nonnull ChannelService channelService, @Nonnull TypeService typeService) {
        super(new InventorySyncStatistics(), syncOptions);
        this.inventoryService = inventoryService;
        this.referenceResolver = new InventoryReferenceResolver(syncOptions, typeService, channelService);
    }

    @Override
    @Nonnull
    protected CompletionStage<InventorySyncStatistics> process(@Nonnull List<InventoryEntryDraft> inventories) {
        List validInventories = inventories.stream().filter(this::validateDraft).collect(Collectors.toList());
        return CompletableFuture.allOf((CompletableFuture[])IntStream.range(0, this.calculateNumberOfBatches(validInventories.size())).mapToObj(batchIndex -> this.getBatch(batchIndex, validInventories)).map(this::processBatch).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new)).thenApply(v -> {
            ((InventorySyncStatistics)this.statistics).incrementProcessed(inventories.size());
            return (InventorySyncStatistics)this.statistics;
        });
    }

    private boolean validateDraft(@Nullable InventoryEntryDraft draft) {
        if (draft == null) {
            this.handleError(INVENTORY_DRAFT_IS_NULL, null, 1);
        } else if (StringUtils.isBlank((CharSequence)draft.getSku())) {
            this.handleError(INVENTORY_DRAFT_HAS_NO_SKU, null, 1);
        } else {
            return true;
        }
        return false;
    }

    private int calculateNumberOfBatches(int listSize) {
        return (listSize + ((InventorySyncOptions)this.syncOptions).getBatchSize() - 1) / ((InventorySyncOptions)this.syncOptions).getBatchSize();
    }

    @Nonnull
    private List<InventoryEntryDraft> getBatch(int batchIndex, @Nonnull List<InventoryEntryDraft> drafts) {
        int startIndex = batchIndex * ((InventorySyncOptions)this.syncOptions).getBatchSize();
        int endIndex = Math.min((batchIndex + 1) * ((InventorySyncOptions)this.syncOptions).getBatchSize(), drafts.size());
        return drafts.subList(startIndex, endIndex);
    }

    @Override
    protected CompletionStage<InventorySyncStatistics> processBatch(@Nonnull List<InventoryEntryDraft> batchOfDrafts) {
        return this.fetchExistingInventories(batchOfDrafts).thenCompose(oldInventoriesOptional -> oldInventoriesOptional.map(oldInventories -> this.syncBatch((List<InventoryEntry>)oldInventories, batchOfDrafts)).orElseGet(() -> CompletableFuture.completedFuture(this.statistics)));
    }

    private CompletionStage<Optional<List<InventoryEntry>>> fetchExistingInventories(@Nonnull List<InventoryEntryDraft> drafts) {
        Set<String> skus = this.extractSkus(drafts);
        return this.inventoryService.fetchInventoryEntriesBySkus(skus).thenApply(Optional::of).exceptionally(exception -> {
            String errorMessage = String.format(CTP_INVENTORY_FETCH_FAILED, this.extractSkus(drafts));
            this.handleError(errorMessage, (Throwable)exception, drafts.size());
            return Optional.empty();
        });
    }

    private CompletionStage<InventorySyncStatistics> syncBatch(@Nonnull List<InventoryEntry> oldInventories, @Nonnull List<InventoryEntryDraft> inventoryEntryDrafts) {
        Map identifierToOldInventoryEntry = oldInventories.stream().collect(Collectors.toMap(InventoryEntryIdentifier::of, Function.identity()));
        ArrayList futures = new ArrayList(inventoryEntryDrafts.size());
        inventoryEntryDrafts.forEach(inventoryEntryDraft -> futures.add(this.referenceResolver.resolveReferences((InventoryEntryDraft)inventoryEntryDraft).thenCompose(resolvedDraft -> this.syncDraft(identifierToOldInventoryEntry, (InventoryEntryDraft)resolvedDraft)).exceptionally(referenceResolutionException -> {
            String errorMessage = String.format(FAILED_TO_RESOLVE_REFERENCES, inventoryEntryDraft.getSku(), referenceResolutionException.getMessage());
            this.handleError(errorMessage, (Throwable)referenceResolutionException, 1);
            return null;
        }).toCompletableFuture()));
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(result -> (InventorySyncStatistics)this.statistics);
    }

    private Set<String> extractSkus(@Nonnull List<InventoryEntryDraft> inventories) {
        return inventories.stream().map(InventoryEntryDraft::getSku).collect(Collectors.toSet());
    }

    private CompletableFuture<Void> syncDraft(@Nonnull Map<InventoryEntryIdentifier, InventoryEntry> oldInventories, @Nonnull InventoryEntryDraft resolvedDraft) {
        InventoryEntry oldInventory = oldInventories.get(InventoryEntryIdentifier.of(resolvedDraft));
        return oldInventory != null ? this.buildUpdateActionsAndUpdate(oldInventory, resolvedDraft).toCompletableFuture() : this.create(resolvedDraft).toCompletableFuture();
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Void> buildUpdateActionsAndUpdate(@Nonnull InventoryEntry entry, @Nonnull InventoryEntryDraft draft) {
        List updateActions = InventorySyncUtils.buildActions(entry, draft, (InventorySyncOptions)this.syncOptions);
        List<UpdateAction<InventoryEntry>> beforeUpdateCallBackApplied = ((InventorySyncOptions)this.syncOptions).applyBeforeUpdateCallBack(updateActions, draft, entry);
        if (!beforeUpdateCallBackApplied.isEmpty()) {
            return this.inventoryService.updateInventoryEntry(entry, beforeUpdateCallBackApplied).thenAccept(updatedInventory -> ((InventorySyncStatistics)this.statistics).incrementUpdated()).exceptionally(exception -> {
                ResourceIdentifier supplyChannel = draft.getSupplyChannel();
                String errorMessage = String.format(CTP_INVENTORY_ENTRY_UPDATE_FAILED, draft.getSku(), supplyChannel != null ? supplyChannel.getId() : null);
                this.handleError(errorMessage, (Throwable)exception, 1);
                return null;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletionStage<Void> create(@Nonnull InventoryEntryDraft draft) {
        return ((InventorySyncOptions)this.syncOptions).applyBeforeCreateCallBack(draft).map(this.inventoryService::createInventoryEntry).map(creationFuture -> creationFuture.thenAccept(createdInventory -> ((InventorySyncStatistics)this.statistics).incrementCreated()).exceptionally(exception -> {
            ResourceIdentifier supplyChannelIdentifier = draft.getSupplyChannel();
            String errorMessage = String.format(CTP_INVENTORY_ENTRY_CREATE_FAILED, draft.getSku(), supplyChannelIdentifier != null ? supplyChannelIdentifier.getId() : null);
            this.handleError(errorMessage, (Throwable)exception, 1);
            return null;
        })).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    private void handleError(@Nonnull String errorMessage, @Nullable Throwable exception, int failedTimes) {
        ((InventorySyncOptions)this.syncOptions).applyErrorCallback(errorMessage, exception);
        ((InventorySyncStatistics)this.statistics).incrementFailed(failedTimes);
    }
}

