/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.utils;

import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import io.sphere.sdk.inventory.commands.updateactions.ChangeQuantity;
import io.sphere.sdk.inventory.commands.updateactions.SetExpectedDelivery;
import io.sphere.sdk.inventory.commands.updateactions.SetRestockableInDays;
import io.sphere.sdk.inventory.commands.updateactions.SetSupplyChannel;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.ResourceIdentifier;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.math.NumberUtils;

public final class InventoryUpdateActionUtils {
    @Nonnull
    public static Optional<UpdateAction<InventoryEntry>> buildChangeQuantityAction(@Nonnull InventoryEntry oldEntry, @Nonnull InventoryEntryDraft newEntry) {
        Long oldQuantityOnStock = oldEntry.getQuantityOnStock();
        Long newQuantityOnStock = newEntry.getQuantityOnStock() == null ? NumberUtils.LONG_ZERO : newEntry.getQuantityOnStock();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldQuantityOnStock, newQuantityOnStock, () -> ChangeQuantity.of((long)newQuantityOnStock));
    }

    @Nonnull
    public static Optional<UpdateAction<InventoryEntry>> buildSetRestockableInDaysAction(@Nonnull InventoryEntry oldEntry, @Nonnull InventoryEntryDraft newEntry) {
        Integer oldRestockableInDays = oldEntry.getRestockableInDays();
        Integer newRestockableInDays = newEntry.getRestockableInDays();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldRestockableInDays, newRestockableInDays, () -> SetRestockableInDays.of((Integer)newRestockableInDays));
    }

    @Nonnull
    public static Optional<UpdateAction<InventoryEntry>> buildSetExpectedDeliveryAction(@Nonnull InventoryEntry oldEntry, @Nonnull InventoryEntryDraft newEntry) {
        ZonedDateTime oldExpectedDelivery = oldEntry.getExpectedDelivery();
        ZonedDateTime newExpectedDelivery = newEntry.getExpectedDelivery();
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldExpectedDelivery, newExpectedDelivery, () -> SetExpectedDelivery.of((ZonedDateTime)newExpectedDelivery));
    }

    @Nonnull
    public static Optional<UpdateAction<InventoryEntry>> buildSetSupplyChannelAction(@Nonnull InventoryEntry oldEntry, @Nonnull InventoryEntryDraft newEntry) {
        Reference oldSupplyChannel = oldEntry.getSupplyChannel();
        ResourceIdentifier newSupplyChannel = newEntry.getSupplyChannel();
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldSupplyChannel, newSupplyChannel, () -> SetSupplyChannel.of((ResourceIdentifier)newSupplyChannel));
    }

    private InventoryUpdateActionUtils() {
    }
}

