/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.products.ActionGroup;
import com.commercetools.sync.products.AttributeMetaData;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.SyncFilter;
import com.commercetools.sync.products.utils.ProductUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductDraft;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class ProductSyncUtils {
    @Nonnull
    public static List<UpdateAction<Product>> buildActions(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct, @Nonnull ProductSyncOptions syncOptions, @Nonnull Map<String, AttributeMetaData> attributesMetaData) {
        SyncFilter syncFilter = syncOptions.getSyncFilter();
        ArrayList<UpdateAction<Product>> updateActions = new ArrayList<UpdateAction<Product>>(OptionalUtils.filterEmptyOptionals(ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.NAME, () -> ProductUpdateActionUtils.buildChangeNameUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.DESCRIPTION, () -> ProductUpdateActionUtils.buildSetDescriptionUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.SLUG, () -> ProductUpdateActionUtils.buildChangeSlugUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.SEARCHKEYWORDS, () -> ProductUpdateActionUtils.buildSetSearchKeywordsUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.METATITLE, () -> ProductUpdateActionUtils.buildSetMetaTitleUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.METADESCRIPTION, () -> ProductUpdateActionUtils.buildSetMetaDescriptionUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.METAKEYWORDS, () -> ProductUpdateActionUtils.buildSetMetaKeywordsUpdateAction(oldProduct, newProduct)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.TAXCATEGORY, () -> ProductUpdateActionUtils.buildSetTaxCategoryUpdateAction(oldProduct, newProduct).map(action -> action)), ProductUpdateActionUtils.buildActionIfPassesFilter(syncFilter, ActionGroup.STATE, () -> ProductUpdateActionUtils.buildTransitionStateUpdateAction(oldProduct, newProduct).map(action -> action))));
        List productCategoryUpdateActions = ProductUpdateActionUtils.buildActionsIfPassesFilter(syncFilter, ActionGroup.CATEGORIES, () -> ProductSyncUtils.buildCategoryActions(oldProduct, newProduct));
        updateActions.addAll(productCategoryUpdateActions);
        updateActions.addAll(ProductUpdateActionUtils.buildVariantsUpdateActions(oldProduct, newProduct, syncOptions, attributesMetaData));
        ProductUpdateActionUtils.buildPublishUpdateAction(oldProduct, newProduct).ifPresent(updateActions::add);
        return updateActions;
    }

    @Nonnull
    public static List<UpdateAction<Product>> buildCategoryActions(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        ArrayList<UpdateAction<Product>> updateActions = new ArrayList<UpdateAction<Product>>();
        updateActions.addAll(ProductUpdateActionUtils.buildAddToCategoryUpdateActions(oldProduct, newProduct));
        updateActions.addAll(ProductUpdateActionUtils.buildSetCategoryOrderHintUpdateActions(oldProduct, newProduct));
        updateActions.addAll(ProductUpdateActionUtils.buildRemoveFromCategoryUpdateActions(oldProduct, newProduct));
        return updateActions;
    }

    private ProductSyncUtils() {
    }
}

