/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.commons.utils.CtpQueryUtils;
import com.commercetools.sync.services.CategoryService;
import com.commercetools.sync.services.impl.BaseService;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.categories.CategoryDraft;
import io.sphere.sdk.categories.commands.CategoryCreateCommand;
import io.sphere.sdk.categories.commands.CategoryUpdateCommand;
import io.sphere.sdk.categories.expansion.CategoryExpansionModel;
import io.sphere.sdk.categories.queries.CategoryQuery;
import io.sphere.sdk.categories.queries.CategoryQueryBuilder;
import io.sphere.sdk.categories.queries.CategoryQueryModel;
import io.sphere.sdk.commands.UpdateAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class CategoryServiceImpl
extends BaseService<CategoryDraft, Category, CategorySyncOptions, CategoryQuery, CategoryQueryModel, CategoryExpansionModel<Category>>
implements CategoryService {
    private static final String CATEGORY_KEY_NOT_SET = "Category with id: '%s' has no key set. Keys are required for category matching.";

    public CategoryServiceImpl(@Nonnull CategorySyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds() {
        if (this.isCached) {
            return CompletableFuture.completedFuture(this.keyToIdCache);
        }
        Consumer categoryPageConsumer = categoriesPage -> categoriesPage.forEach(category -> {
            String key = category.getKey();
            String id = category.getId();
            if (StringUtils.isNotBlank((CharSequence)key)) {
                this.keyToIdCache.put(key, id);
            } else {
                ((CategorySyncOptions)this.syncOptions).applyWarningCallback(String.format(CATEGORY_KEY_NOT_SET, id));
            }
        });
        return CtpQueryUtils.queryAll(((CategorySyncOptions)this.syncOptions).getCtpClient(), CategoryQuery.of(), categoryPageConsumer).thenAccept(result -> {
            this.isCached = true;
        }).thenApply(result -> this.keyToIdCache);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<Category>> fetchMatchingCategoriesByKeys(@Nonnull Set<String> categoryKeys) {
        return this.fetchMatchingResources(categoryKeys, () -> CategoryQuery.of().plusPredicates(categoryQueryModel -> categoryQueryModel.key().isIn((Iterable)categoryKeys)));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Category>> fetchCategory(@Nullable String key) {
        return this.fetchResource(key, () -> CategoryQuery.of().plusPredicates(categoryQueryModel -> categoryQueryModel.key().is(key)));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedCategoryId(@Nonnull String key) {
        return this.fetchCachedResourceId(key, () -> CategoryQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().isIn(Collections.singleton(key))).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Category>> createCategory(@Nonnull CategoryDraft categoryDraft) {
        return this.createResource(categoryDraft, CategoryDraft::getKey, CategoryCreateCommand::of);
    }

    @Override
    @Nonnull
    public CompletionStage<Category> updateCategory(@Nonnull Category category, @Nonnull List<UpdateAction<Category>> updateActions) {
        return this.updateResource(category, CategoryUpdateCommand::of, updateActions);
    }
}

