/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.utils.CtpQueryUtils;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.services.TaxCategoryService;
import io.sphere.sdk.taxcategories.queries.TaxCategoryQuery;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class TaxCategoryServiceImpl
implements TaxCategoryService {
    private final ProductSyncOptions syncOptions;
    private final Map<String, String> keyToIdCache = new ConcurrentHashMap<String, String>();

    public TaxCategoryServiceImpl(@Nonnull ProductSyncOptions syncOptions) {
        this.syncOptions = syncOptions;
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedTaxCategoryId(@Nullable String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (this.keyToIdCache.isEmpty()) {
            return this.fetchAndCache(key);
        }
        return CompletableFuture.completedFuture(Optional.ofNullable(this.keyToIdCache.get(key)));
    }

    @Nonnull
    private CompletionStage<Optional<String>> fetchAndCache(@Nonnull String key) {
        Consumer taxCategoryPageConsumer = taxCategoryPage -> taxCategoryPage.forEach(taxCategory -> {
            String fetchedTaxCategoryKey = taxCategory.getKey();
            String id = taxCategory.getId();
            if (StringUtils.isNotBlank((CharSequence)fetchedTaxCategoryKey)) {
                this.keyToIdCache.put(fetchedTaxCategoryKey, id);
            } else {
                this.syncOptions.applyWarningCallback(String.format("TaxCategory with id: '%s' has no key set. Keys are required for taxCategory matching.", id));
            }
        });
        return CtpQueryUtils.queryAll(this.syncOptions.getCtpClient(), TaxCategoryQuery.of(), taxCategoryPageConsumer).thenApply(result -> Optional.ofNullable(this.keyToIdCache.get(key)));
    }
}

