/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons;

import com.commercetools.sync.commons.utils.CollectionUtils;
import com.commercetools.sync.commons.utils.TriFunction;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.commands.UpdateAction;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BaseSyncOptions<U, V> {
    private final SphereClient ctpClient;
    private final BiConsumer<String, Throwable> errorCallBack;
    private final Consumer<String> warningCallBack;
    private int batchSize;
    private final TriFunction<List<UpdateAction<U>>, V, U, List<UpdateAction<U>>> beforeUpdateCallback;
    private final Function<V, V> beforeCreateCallback;

    protected BaseSyncOptions(@Nonnull SphereClient ctpClient, @Nullable BiConsumer<String, Throwable> errorCallBack, @Nullable Consumer<String> warningCallBack, int batchSize, @Nullable TriFunction<List<UpdateAction<U>>, V, U, List<UpdateAction<U>>> beforeUpdateCallback, @Nullable Function<V, V> beforeCreateCallback) {
        this.ctpClient = ctpClient;
        this.errorCallBack = errorCallBack;
        this.batchSize = batchSize;
        this.warningCallBack = warningCallBack;
        this.beforeUpdateCallback = beforeUpdateCallback;
        this.beforeCreateCallback = beforeCreateCallback;
    }

    public SphereClient getCtpClient() {
        return this.ctpClient;
    }

    @Nullable
    public BiConsumer<String, Throwable> getErrorCallBack() {
        return this.errorCallBack;
    }

    @Nullable
    public Consumer<String> getWarningCallBack() {
        return this.warningCallBack;
    }

    public void applyWarningCallback(@Nonnull String warningMessage) {
        if (this.warningCallBack != null) {
            this.warningCallBack.accept(warningMessage);
        }
    }

    public void applyErrorCallback(@Nonnull String errorMessage, @Nullable Throwable exception) {
        if (this.errorCallBack != null) {
            this.errorCallBack.accept(errorMessage, exception);
        }
    }

    public void applyErrorCallback(@Nonnull String errorMessage) {
        this.applyErrorCallback(errorMessage, null);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @Nullable
    public TriFunction<List<UpdateAction<U>>, V, U, List<UpdateAction<U>>> getBeforeUpdateCallback() {
        return this.beforeUpdateCallback;
    }

    @Nullable
    public Function<V, V> getBeforeCreateCallback() {
        return this.beforeCreateCallback;
    }

    @Nonnull
    public List<UpdateAction<U>> applyBeforeUpdateCallBack(@Nonnull List<UpdateAction<U>> updateActions, @Nonnull V newResourceDraft, @Nonnull U oldResource) {
        return Optional.ofNullable(this.beforeUpdateCallback).filter(callback -> !updateActions.isEmpty()).map(filteredCallback -> CollectionUtils.emptyIfNull((List)filteredCallback.apply(updateActions, newResourceDraft, oldResource))).orElse(updateActions);
    }

    @Nonnull
    public Optional<V> applyBeforeCreateCallBack(@Nonnull V newResourceDraft) {
        return Optional.ofNullable(this.beforeCreateCallback != null ? this.beforeCreateCallback.apply(newResourceDraft) : newResourceDraft);
    }
}

