/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.BaseReferenceResolver;
import com.commercetools.sync.services.TypeService;
import io.sphere.sdk.models.Builder;
import io.sphere.sdk.types.CustomDraft;
import io.sphere.sdk.types.CustomFieldsDraft;
import io.sphere.sdk.utils.CompletableFutureUtils;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class CustomReferenceResolver<D extends CustomDraft, B extends Builder<? extends D>, S extends BaseSyncOptions>
extends BaseReferenceResolver<D, S> {
    private TypeService typeService;

    protected CustomReferenceResolver(@Nonnull S options, @Nonnull TypeService typeService) {
        super(options);
        this.typeService = typeService;
    }

    protected abstract CompletionStage<B> resolveCustomTypeReference(@Nonnull B var1);

    @Nonnull
    protected CompletionStage<B> resolveCustomTypeReference(@Nonnull B draftBuilder, @Nonnull Function<B, CustomFieldsDraft> customGetter, @Nonnull BiFunction<B, CustomFieldsDraft, B> customSetter, @Nonnull String errorMessage) {
        CustomFieldsDraft custom = customGetter.apply(draftBuilder);
        if (custom != null) {
            return this.getCustomTypeId(custom, errorMessage).thenApply(resolvedTypeIdOptional -> resolvedTypeIdOptional.map(resolvedTypeId -> (Builder)customSetter.apply(draftBuilder, CustomFieldsDraft.ofTypeIdAndJson((String)resolvedTypeId, (Map)custom.getFields()))).orElse((Builder)draftBuilder));
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    private CompletionStage<Optional<String>> getCustomTypeId(@Nonnull CustomFieldsDraft custom, @Nonnull String referenceResolutionErrorMessage) {
        try {
            String customTypeKey = CustomReferenceResolver.getKeyFromResourceIdentifier(custom.getType());
            return this.typeService.fetchCachedTypeId(customTypeKey);
        }
        catch (ReferenceResolutionException exception) {
            String errorMessage = String.format("%s Reason: %s", referenceResolutionErrorMessage, exception.getMessage());
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(errorMessage, exception));
        }
    }
}

