/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.fasterxml.jackson.databind.JsonNode;
import io.sphere.sdk.models.Referenceable;
import io.sphere.sdk.models.ResourceIdentifier;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ResourceIdentifierUtils {
    public static final String REFERENCE_TYPE_ID_FIELD = "typeId";
    public static final String REFERENCE_ID_FIELD = "id";

    @Nullable
    public static <T extends Referenceable<S>, S> ResourceIdentifier<S> toResourceIdentifierIfNotNull(@Nullable T resource) {
        return Optional.ofNullable(resource).map(Referenceable::toResourceIdentifier).orElse(null);
    }

    public static boolean isReferenceOfType(@Nonnull JsonNode referenceValue, String referenceTypeId) {
        return ResourceIdentifierUtils.getReferenceTypeId(referenceValue).map(resolvedReferenceTypeId -> Objects.equals(resolvedReferenceTypeId, referenceTypeId)).orElse(false);
    }

    @Nonnull
    private static Optional<String> getReferenceTypeId(@Nonnull JsonNode referenceValue) {
        JsonNode typeId = referenceValue.get(REFERENCE_TYPE_ID_FIELD);
        return Optional.ofNullable(typeId).map(JsonNode::asText);
    }

    private ResourceIdentifierUtils() {
    }
}

