/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories;

import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.inventories.InventorySyncOptions;
import com.commercetools.sync.inventories.helpers.InventoryEntryIdentifier;
import com.commercetools.sync.inventories.helpers.InventoryReferenceResolver;
import com.commercetools.sync.inventories.helpers.InventorySyncStatistics;
import com.commercetools.sync.inventories.utils.InventorySyncUtils;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.InventoryService;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.impl.ChannelServiceImpl;
import com.commercetools.sync.services.impl.InventoryServiceImpl;
import com.commercetools.sync.services.impl.TypeServiceImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sphere.sdk.channels.ChannelRole;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import io.sphere.sdk.models.ResourceIdentifier;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public final class InventorySync
extends BaseSync<InventoryEntryDraft, InventorySyncStatistics, InventorySyncOptions> {
    private static final String CTP_INVENTORY_FETCH_FAILED = "Failed to fetch existing inventory entries of SKUs %s.";
    private static final String CTP_INVENTORY_ENTRY_UPDATE_FAILED = "Failed to update inventory entry of SKU '%s' and supply channel id '%s'.";
    private static final String INVENTORY_DRAFT_HAS_NO_SKU = "Failed to process inventory entry without SKU.";
    private static final String INVENTORY_DRAFT_IS_NULL = "Failed to process null inventory draft.";
    private static final String FAILED_TO_RESOLVE_REFERENCES = "Failed to resolve references on InventoryEntryDraft with SKU:'%s'. Reason: %s";
    private final InventoryService inventoryService;
    private final InventoryReferenceResolver referenceResolver;

    public InventorySync(@Nonnull InventorySyncOptions syncOptions) {
        this(syncOptions, new InventoryServiceImpl(syncOptions), new ChannelServiceImpl(syncOptions, Collections.singleton(ChannelRole.INVENTORY_SUPPLY)), new TypeServiceImpl(syncOptions));
    }

    InventorySync(@Nonnull InventorySyncOptions syncOptions, @Nonnull InventoryService inventoryService, @Nonnull ChannelService channelService, @Nonnull TypeService typeService) {
        super(new InventorySyncStatistics(), syncOptions);
        this.inventoryService = inventoryService;
        this.referenceResolver = new InventoryReferenceResolver(syncOptions, typeService, channelService);
    }

    @Override
    @Nonnull
    protected CompletionStage<InventorySyncStatistics> process(@Nonnull List<InventoryEntryDraft> inventoryEntryDrafts) {
        List batches = SyncUtils.batchElements(inventoryEntryDrafts, ((InventorySyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture(this.statistics));
    }

    @Override
    protected CompletionStage<InventorySyncStatistics> processBatch(@Nonnull List<InventoryEntryDraft> batch) {
        List validDrafts = batch.stream().filter(this::validateDraft).collect(Collectors.toList());
        if (validDrafts.isEmpty()) {
            ((InventorySyncStatistics)this.statistics).incrementProcessed(batch.size());
            return CompletableFuture.completedFuture(this.statistics);
        }
        Set<String> skus = validDrafts.stream().map(InventoryEntryDraft::getSku).collect(Collectors.toSet());
        return this.inventoryService.fetchInventoryEntriesBySkus(skus).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Set fetchedInventoryEntries = (Set)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_INVENTORY_FETCH_FAILED, skus);
                this.handleError(errorMessage, exception, skus.size());
                return CompletableFuture.completedFuture(null);
            }
            return this.syncBatch(fetchedInventoryEntries, validDrafts);
        }).thenApply(ignored -> {
            ((InventorySyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (InventorySyncStatistics)this.statistics;
        });
    }

    private boolean validateDraft(@Nullable InventoryEntryDraft draft) {
        if (draft == null) {
            this.handleError(INVENTORY_DRAFT_IS_NULL, null, 1);
        } else if (StringUtils.isBlank((CharSequence)draft.getSku())) {
            this.handleError(INVENTORY_DRAFT_HAS_NO_SKU, null, 1);
        } else {
            return true;
        }
        return false;
    }

    private CompletionStage<Void> syncBatch(@Nonnull Set<InventoryEntry> oldInventories, @Nonnull List<InventoryEntryDraft> inventoryEntryDrafts) {
        Map oldInventoryMap = oldInventories.stream().collect(Collectors.toMap(InventoryEntryIdentifier::of, Function.identity()));
        return CompletableFuture.allOf((CompletableFuture[])inventoryEntryDrafts.stream().map(newInventoryEntry -> this.referenceResolver.resolveReferences((InventoryEntryDraft)newInventoryEntry).thenCompose(resolvedDraft -> this.syncDraft(oldInventoryMap, (InventoryEntryDraft)resolvedDraft)).exceptionally(referenceResolutionException -> {
            String errorMessage = String.format(FAILED_TO_RESOLVE_REFERENCES, newInventoryEntry.getSku(), referenceResolutionException.getMessage());
            this.handleError(errorMessage, (Throwable)referenceResolutionException, 1);
            return Optional.empty();
        })).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    private CompletionStage<Optional<InventoryEntry>> syncDraft(@Nonnull Map<InventoryEntryIdentifier, InventoryEntry> oldInventories, @Nonnull InventoryEntryDraft resolvedDraft) {
        InventoryEntry oldInventory = oldInventories.get(InventoryEntryIdentifier.of(resolvedDraft));
        return Optional.ofNullable(oldInventory).map(type -> this.buildActionsAndUpdate(oldInventory, resolvedDraft)).orElseGet(() -> this.applyCallbackAndCreate(resolvedDraft));
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Optional<InventoryEntry>> buildActionsAndUpdate(@Nonnull InventoryEntry entry, @Nonnull InventoryEntryDraft draft) {
        List updateActions = InventorySyncUtils.buildActions(entry, draft, (InventorySyncOptions)this.syncOptions);
        List<UpdateAction<InventoryEntry>> beforeUpdateCallBackApplied = ((InventorySyncOptions)this.syncOptions).applyBeforeUpdateCallBack(updateActions, draft, entry);
        if (!beforeUpdateCallBackApplied.isEmpty()) {
            return this.inventoryService.updateInventoryEntry(entry, beforeUpdateCallBackApplied).handle(ImmutablePair::new).thenCompose(updateResponse -> {
                InventoryEntry updatedInventoryEntry = (InventoryEntry)updateResponse.getKey();
                Throwable sphereException = (Throwable)updateResponse.getValue();
                if (sphereException != null) {
                    ResourceIdentifier supplyChannel = draft.getSupplyChannel();
                    String errorMessage = String.format(CTP_INVENTORY_ENTRY_UPDATE_FAILED, draft.getSku(), supplyChannel != null ? supplyChannel.getId() : null);
                    this.handleError(errorMessage, sphereException, 1);
                    return CompletableFuture.completedFuture(Optional.empty());
                }
                ((InventorySyncStatistics)this.statistics).incrementUpdated();
                return CompletableFuture.completedFuture(Optional.of(updatedInventoryEntry));
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletionStage<Optional<InventoryEntry>> applyCallbackAndCreate(@Nonnull InventoryEntryDraft inventoryEntryDraft) {
        return ((InventorySyncOptions)this.syncOptions).applyBeforeCreateCallBack(inventoryEntryDraft).map(draft -> this.inventoryService.createInventoryEntry((InventoryEntryDraft)draft).thenApply(inventoryEntryOptional -> {
            if (inventoryEntryOptional.isPresent()) {
                ((InventorySyncStatistics)this.statistics).incrementCreated();
            } else {
                ((InventorySyncStatistics)this.statistics).incrementFailed();
            }
            return inventoryEntryOptional;
        })).orElse(CompletableFuture.completedFuture(Optional.empty()));
    }

    private void handleError(@Nonnull String errorMessage, @Nullable Throwable exception, int failedTimes) {
        ((InventorySyncOptions)this.syncOptions).applyErrorCallback(errorMessage, exception);
        ((InventorySyncStatistics)this.statistics).incrementFailed(failedTimes);
    }
}

