/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.utils;

import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.inventories.InventorySyncOptions;
import com.commercetools.sync.inventories.helpers.InventoryCustomActionBuilder;
import com.commercetools.sync.inventories.utils.InventoryUpdateActionUtils;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.inventory.InventoryEntry;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import java.util.List;
import javax.annotation.Nonnull;

public final class InventorySyncUtils {
    private static final InventoryCustomActionBuilder inventoryCustomActionBuilder = new InventoryCustomActionBuilder();

    @Nonnull
    public static List<UpdateAction<InventoryEntry>> buildActions(@Nonnull InventoryEntry oldEntry, @Nonnull InventoryEntryDraft newEntry, @Nonnull InventorySyncOptions syncOptions) {
        List<UpdateAction<InventoryEntry>> actions = OptionalUtils.filterEmptyOptionals(InventoryUpdateActionUtils.buildChangeQuantityAction(oldEntry, newEntry), InventoryUpdateActionUtils.buildSetRestockableInDaysAction(oldEntry, newEntry), InventoryUpdateActionUtils.buildSetExpectedDeliveryAction(oldEntry, newEntry), InventoryUpdateActionUtils.buildSetSupplyChannelAction(oldEntry, newEntry));
        actions.addAll(CustomUpdateActionUtils.buildPrimaryResourceCustomUpdateActions(oldEntry, newEntry, inventoryCustomActionBuilder, syncOptions));
        return actions;
    }

    private InventorySyncUtils() {
    }
}

