/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products;

import com.commercetools.sync.categories.CategorySyncOptionsBuilder;
import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.models.WaitingToBeResolved;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.ProductBatchProcessor;
import com.commercetools.sync.products.helpers.ProductReferenceResolver;
import com.commercetools.sync.products.helpers.ProductSyncStatistics;
import com.commercetools.sync.products.utils.ProductSyncUtils;
import com.commercetools.sync.products.utils.ProductUpdateActionUtils;
import com.commercetools.sync.services.CategoryService;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.CustomerGroupService;
import com.commercetools.sync.services.ProductService;
import com.commercetools.sync.services.ProductTypeService;
import com.commercetools.sync.services.StateService;
import com.commercetools.sync.services.TaxCategoryService;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.UnresolvedReferencesService;
import com.commercetools.sync.services.impl.CategoryServiceImpl;
import com.commercetools.sync.services.impl.ChannelServiceImpl;
import com.commercetools.sync.services.impl.CustomerGroupServiceImpl;
import com.commercetools.sync.services.impl.ProductServiceImpl;
import com.commercetools.sync.services.impl.ProductTypeServiceImpl;
import com.commercetools.sync.services.impl.StateServiceImpl;
import com.commercetools.sync.services.impl.TaxCategoryServiceImpl;
import com.commercetools.sync.services.impl.TypeServiceImpl;
import com.commercetools.sync.services.impl.UnresolvedReferencesServiceImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sphere.sdk.channels.ChannelRole;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.ProductLike;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ProductSync
extends BaseSync<ProductDraft, ProductSyncStatistics, ProductSyncOptions> {
    private static final String CTP_PRODUCT_FETCH_FAILED = "Failed to fetch existing products with keys: '%s'.";
    private static final String UNRESOLVED_REFERENCES_STORE_FETCH_FAILED = "Failed to fetch ProductDrafts waiting to be resolved with keys '%s'.";
    private static final String UPDATE_FAILED = "Failed to update Product with key: '%s'. Reason: %s";
    private static final String FAILED_TO_RESOLVE_REFERENCES = "Failed to resolve references on ProductDraft with key:'%s'. Reason: %s";
    private static final String FAILED_TO_FETCH_PRODUCT_TYPE = "Failed to fetch a productType for the product to build the products' attributes metadata.";
    private final ProductService productService;
    private final ProductTypeService productTypeService;
    private final ProductReferenceResolver productReferenceResolver;
    private final UnresolvedReferencesService unresolvedReferencesService;
    private ConcurrentHashMap.KeySetView<String, Boolean> readyToResolve;

    public ProductSync(@Nonnull ProductSyncOptions productSyncOptions) {
        this(productSyncOptions, new ProductServiceImpl(productSyncOptions), new ProductTypeServiceImpl(productSyncOptions), new CategoryServiceImpl(CategorySyncOptionsBuilder.of(productSyncOptions.getCtpClient()).build()), new TypeServiceImpl(productSyncOptions), new ChannelServiceImpl(productSyncOptions, Collections.singleton(ChannelRole.PRODUCT_DISTRIBUTION)), new CustomerGroupServiceImpl(productSyncOptions), new TaxCategoryServiceImpl(productSyncOptions), new StateServiceImpl(productSyncOptions), new UnresolvedReferencesServiceImpl(productSyncOptions));
    }

    ProductSync(@Nonnull ProductSyncOptions productSyncOptions, @Nonnull ProductService productService, @Nonnull ProductTypeService productTypeService, @Nonnull CategoryService categoryService, @Nonnull TypeService typeService, @Nonnull ChannelService channelService, @Nonnull CustomerGroupService customerGroupService, @Nonnull TaxCategoryService taxCategoryService, @Nonnull StateService stateService, @Nonnull UnresolvedReferencesService unresolvedReferencesService) {
        super(new ProductSyncStatistics(), productSyncOptions);
        this.productService = productService;
        this.productTypeService = productTypeService;
        this.productReferenceResolver = new ProductReferenceResolver(productSyncOptions, productTypeService, categoryService, typeService, channelService, customerGroupService, taxCategoryService, stateService, productService);
        this.unresolvedReferencesService = unresolvedReferencesService;
    }

    @Override
    protected CompletionStage<ProductSyncStatistics> process(@Nonnull List<ProductDraft> resourceDrafts) {
        List batches = SyncUtils.batchElements(resourceDrafts, ((ProductSyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture(this.statistics));
    }

    @Override
    protected CompletionStage<ProductSyncStatistics> processBatch(@Nonnull List<ProductDraft> batch) {
        this.readyToResolve = ConcurrentHashMap.newKeySet();
        ProductBatchProcessor batchProcessor = new ProductBatchProcessor(batch, this);
        batchProcessor.validateBatch();
        Set<ProductDraft> validDrafts = batchProcessor.getValidDrafts();
        if (validDrafts.isEmpty()) {
            ((ProductSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return CompletableFuture.completedFuture(this.statistics);
        }
        Set<String> keysToCache = batchProcessor.getKeysToCache();
        return this.productService.cacheKeysToIds(keysToCache).handle(ImmutablePair::new).thenCompose(cachingResponse -> {
            Map keyToIdCache = (Map)cachingResponse.getKey();
            Throwable cachingException = (Throwable)cachingResponse.getValue();
            if (cachingException != null) {
                this.handleError("Failed to build a cache of product keys to ids.", cachingException, keysToCache.size());
                return CompletableFuture.completedFuture(null);
            }
            return this.syncBatch(validDrafts, keyToIdCache);
        }).thenApply(ignoredResult -> {
            ((ProductSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (ProductSyncStatistics)this.statistics;
        });
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Void> syncBatch(@Nonnull Set<ProductDraft> productDrafts, @Nonnull Map<String, String> keyToIdCache) {
        if (productDrafts.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        Set<String> productDraftKeys = productDrafts.stream().map(ProductDraft::getKey).collect(Collectors.toSet());
        return this.productService.fetchMatchingProductsByKeys(productDraftKeys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Throwable fetchException = (Throwable)fetchResponse.getValue();
            if (fetchException != null) {
                String errorMessage = String.format(CTP_PRODUCT_FETCH_FAILED, productDraftKeys);
                this.handleError(errorMessage, fetchException, productDraftKeys.size());
                return CompletableFuture.completedFuture(null);
            }
            Set matchingProducts = (Set)fetchResponse.getKey();
            return this.syncOrKeepTrack(productDrafts, matchingProducts, keyToIdCache).thenCompose(aVoid -> this.resolveNowReadyReferences(keyToIdCache));
        });
    }

    @Nonnull
    private CompletionStage<Void> syncOrKeepTrack(@Nonnull Set<ProductDraft> newProducts, @Nonnull Set<Product> oldProducts, @Nonnull Map<String, String> keyToIdCache) {
        return CompletableFuture.allOf((CompletableFuture[])newProducts.stream().map(newDraft -> {
            Set<String> missingReferencedProductKeys = this.getMissingReferencedProductKeys((ProductDraft)newDraft, keyToIdCache);
            if (!missingReferencedProductKeys.isEmpty()) {
                return this.keepTrackOfMissingReferences((ProductDraft)newDraft, missingReferencedProductKeys);
            }
            return this.syncDraft(oldProducts, (ProductDraft)newDraft);
        }).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    private Set<String> getMissingReferencedProductKeys(@Nonnull ProductDraft newProduct, @Nonnull Map<String, String> keyToIdCache) {
        Set referencedProductKeys = ProductUpdateActionUtils.getAllVariants(newProduct).stream().map(ProductBatchProcessor::getReferencedProductKeys).flatMap(Collection::stream).collect(Collectors.toSet());
        return referencedProductKeys.stream().filter(key -> !keyToIdCache.containsKey(key)).collect(Collectors.toSet());
    }

    private CompletionStage<Optional<WaitingToBeResolved>> keepTrackOfMissingReferences(@Nonnull ProductDraft newProduct, @Nonnull Set<String> missingReferencedProductKeys) {
        missingReferencedProductKeys.forEach(missingParentKey -> ((ProductSyncStatistics)this.statistics).addMissingDependency((String)missingParentKey, newProduct.getKey()));
        return this.unresolvedReferencesService.save(new WaitingToBeResolved(newProduct, missingReferencedProductKeys));
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Void> resolveNowReadyReferences(Map<String, String> keyToIdCache) {
        Set<String> referencingDraftKeys = this.readyToResolve.stream().map(((ProductSyncStatistics)this.statistics)::removeAndGetReferencingKeys).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        if (referencingDraftKeys.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        HashSet readyToSync = new HashSet();
        HashSet waitingDraftsToBeUpdated = new HashSet();
        return this.unresolvedReferencesService.fetch(referencingDraftKeys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Set waitingDrafts = (Set)fetchResponse.getKey();
            Throwable fetchException = (Throwable)fetchResponse.getValue();
            if (fetchException != null) {
                String errorMessage = String.format(UNRESOLVED_REFERENCES_STORE_FETCH_FAILED, referencingDraftKeys);
                this.handleError(errorMessage, fetchException, referencingDraftKeys.size());
                return CompletableFuture.completedFuture(null);
            }
            waitingDrafts.forEach(waitingDraft -> {
                Set<String> missingReferencedProductKeys = waitingDraft.getMissingReferencedProductKeys();
                missingReferencedProductKeys.removeAll(this.readyToResolve);
                if (missingReferencedProductKeys.isEmpty()) {
                    readyToSync.add(waitingDraft.getProductDraft());
                } else {
                    waitingDraftsToBeUpdated.add(waitingDraft);
                }
            });
            return ((CompletableFuture)this.updateWaitingDrafts(waitingDraftsToBeUpdated).thenCompose(aVoid -> this.syncBatch(readyToSync, keyToIdCache))).thenCompose(aVoid -> this.removeFromWaiting(readyToSync));
        });
    }

    @Nonnull
    private CompletableFuture<Void> updateWaitingDrafts(@Nonnull Set<WaitingToBeResolved> waitingDraftsToBeUpdated) {
        return CompletableFuture.allOf((CompletableFuture[])waitingDraftsToBeUpdated.stream().map(this.unresolvedReferencesService::save).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    @Nonnull
    private CompletableFuture<Void> removeFromWaiting(@Nonnull Set<ProductDraft> drafts) {
        return CompletableFuture.allOf((CompletableFuture[])drafts.stream().map(ProductDraft::getKey).map(this.unresolvedReferencesService::delete).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    @Nonnull
    private CompletionStage<Void> syncDraft(@Nonnull Set<Product> oldProducts, @Nonnull ProductDraft newProductDraft) {
        Map oldProductMap = oldProducts.stream().collect(Collectors.toMap(ProductLike::getKey, Function.identity()));
        return this.productReferenceResolver.resolveReferences(newProductDraft).thenCompose(resolvedDraft -> {
            Product oldProduct = (Product)oldProductMap.get(newProductDraft.getKey());
            return Optional.ofNullable(oldProduct).map(product -> this.fetchProductAttributesMetadataAndUpdate(oldProduct, (ProductDraft)resolvedDraft)).orElseGet(() -> this.applyCallbackAndCreate((ProductDraft)resolvedDraft));
        }).exceptionally(completionException -> {
            ReferenceResolutionException referenceResolutionException = (ReferenceResolutionException)completionException.getCause();
            String errorMessage = String.format(FAILED_TO_RESOLVE_REFERENCES, newProductDraft.getKey(), referenceResolutionException.getMessage());
            this.handleError(errorMessage, referenceResolutionException, 1);
            return null;
        });
    }

    @Nonnull
    private CompletionStage<Void> fetchProductAttributesMetadataAndUpdate(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        return this.productTypeService.fetchCachedProductAttributeMetaDataMap(oldProduct.getProductType().getId()).thenCompose(optionalAttributesMetaDataMap -> optionalAttributesMetaDataMap.map(attributeMetaDataMap -> {
            List updateActions = ProductSyncUtils.buildActions(oldProduct, newProduct, (ProductSyncOptions)this.syncOptions, attributeMetaDataMap);
            List<UpdateAction<Product>> beforeUpdateCallBackApplied = ((ProductSyncOptions)this.syncOptions).applyBeforeUpdateCallBack(updateActions, newProduct, oldProduct);
            if (!beforeUpdateCallBackApplied.isEmpty()) {
                return this.updateProduct(oldProduct, newProduct, beforeUpdateCallBackApplied);
            }
            return CompletableFuture.completedFuture(null);
        }).orElseGet(() -> {
            String errorMessage = String.format(UPDATE_FAILED, oldProduct.getKey(), FAILED_TO_FETCH_PRODUCT_TYPE);
            this.handleError(errorMessage);
            return CompletableFuture.completedFuture(null);
        }));
    }

    @Nonnull
    private CompletionStage<Void> updateProduct(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct, @Nonnull List<UpdateAction<Product>> updateActions) {
        return this.productService.updateProduct(oldProduct, updateActions).handle(ImmutablePair::new).thenCompose(updateResponse -> {
            Throwable sphereException = (Throwable)updateResponse.getValue();
            if (sphereException != null) {
                return ProductSync.executeSupplierIfConcurrentModificationException(sphereException, () -> this.fetchAndUpdate(oldProduct, newProduct), () -> {
                    String productKey = oldProduct.getKey();
                    this.handleError(String.format(UPDATE_FAILED, productKey, sphereException), sphereException);
                    return CompletableFuture.completedFuture(null);
                });
            }
            ((ProductSyncStatistics)this.statistics).incrementUpdated();
            return CompletableFuture.completedFuture(null);
        });
    }

    @Nonnull
    private CompletionStage<Void> fetchAndUpdate(@Nonnull Product oldProduct, @Nonnull ProductDraft newProduct) {
        String key = oldProduct.getKey();
        return this.productService.fetchProduct(key).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Optional fetchedProductOptional = (Optional)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(UPDATE_FAILED, key, "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(errorMessage, exception);
                return CompletableFuture.completedFuture(null);
            }
            return fetchedProductOptional.map(fetchedProduct -> this.fetchProductAttributesMetadataAndUpdate((Product)fetchedProduct, newProduct)).orElseGet(() -> {
                String errorMessage = String.format(UPDATE_FAILED, key, "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(errorMessage);
                return CompletableFuture.completedFuture(null);
            });
        });
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Void> applyCallbackAndCreate(@Nonnull ProductDraft productDraft) {
        return ((ProductSyncOptions)this.syncOptions).applyBeforeCreateCallBack(productDraft).map(draft -> this.productService.createProduct((ProductDraft)draft).thenAccept(productOptional -> {
            if (productOptional.isPresent()) {
                this.readyToResolve.add(productDraft.getKey());
                ((ProductSyncStatistics)this.statistics).incrementCreated();
            } else {
                ((ProductSyncStatistics)this.statistics).incrementFailed();
            }
        })).orElse(CompletableFuture.completedFuture(null));
    }

    private void handleError(@Nonnull String errorMessage) {
        this.handleError(errorMessage, null);
    }

    private void handleError(@Nonnull String errorMessage, @Nullable Throwable exception) {
        ((ProductSyncOptions)this.syncOptions).applyErrorCallback(errorMessage, exception);
        ((ProductSyncStatistics)this.statistics).incrementFailed();
    }

    private void handleError(@Nonnull String errorMessage, @Nullable Throwable exception, int failedTimes) {
        ((ProductSyncOptions)this.syncOptions).applyErrorCallback(errorMessage, exception);
        ((ProductSyncStatistics)this.statistics).incrementFailed(failedTimes);
    }
}

