/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.helpers;

import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.BaseReferenceResolver;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.VariantReferenceResolver;
import com.commercetools.sync.services.CategoryService;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.CustomerGroupService;
import com.commercetools.sync.services.ProductService;
import com.commercetools.sync.services.ProductTypeService;
import com.commercetools.sync.services.StateService;
import com.commercetools.sync.services.TaxCategoryService;
import com.commercetools.sync.services.TypeService;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.products.CategoryOrderHints;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.ProductDraftBuilder;
import io.sphere.sdk.products.ProductVariantDraft;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.states.State;
import io.sphere.sdk.taxcategories.TaxCategory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProductReferenceResolver
extends BaseReferenceResolver<ProductDraft, ProductSyncOptions> {
    private final ProductTypeService productTypeService;
    private final CategoryService categoryService;
    private final VariantReferenceResolver variantReferenceResolver;
    private final TaxCategoryService taxCategoryService;
    private final StateService stateService;
    private static final String FAILED_TO_RESOLVE_REFERENCE = "Failed to resolve '%s' resource identifier on ProductDraft with key:'%s'. Reason: %s";

    public ProductReferenceResolver(@Nonnull ProductSyncOptions productSyncOptions, @Nonnull ProductTypeService productTypeService, @Nonnull CategoryService categoryService, @Nonnull TypeService typeService, @Nonnull ChannelService channelService, @Nonnull CustomerGroupService customerGroupService, @Nonnull TaxCategoryService taxCategoryService, @Nonnull StateService stateService, @Nonnull ProductService productService) {
        super(productSyncOptions);
        this.productTypeService = productTypeService;
        this.categoryService = categoryService;
        this.taxCategoryService = taxCategoryService;
        this.stateService = stateService;
        this.variantReferenceResolver = new VariantReferenceResolver(productSyncOptions, typeService, channelService, customerGroupService, productService, productTypeService, categoryService);
    }

    @Override
    public CompletionStage<ProductDraft> resolveReferences(@Nonnull ProductDraft productDraft) {
        return this.resolveProductTypeReference(ProductDraftBuilder.of((ProductDraft)productDraft)).thenCompose(this::resolveCategoryReferences).thenCompose(this::resolveAllVariantsReferences).thenCompose(this::resolveTaxCategoryReference).thenCompose(this::resolveStateReference).thenApply(rec$ -> ((ProductDraftBuilder)rec$).build());
    }

    @Nonnull
    private CompletionStage<ProductDraftBuilder> resolveAllVariantsReferences(@Nonnull ProductDraftBuilder draftBuilder) {
        ProductVariantDraft masterVariantDraft = draftBuilder.getMasterVariant();
        if (masterVariantDraft != null) {
            return this.variantReferenceResolver.resolveReferences(masterVariantDraft).thenApply(x$0 -> (ProductDraftBuilder)draftBuilder.masterVariant(x$0)).thenCompose(this::resolveVariantsReferences);
        }
        return this.resolveVariantsReferences(draftBuilder);
    }

    @Nonnull
    private CompletionStage<ProductDraftBuilder> resolveVariantsReferences(@Nonnull ProductDraftBuilder draftBuilder) {
        List productDraftVariants = draftBuilder.getVariants();
        return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(productDraftVariants, this.variantReferenceResolver::resolveReferences, Collectors.toList()).thenApply(arg_0 -> ((ProductDraftBuilder)draftBuilder).variants(arg_0));
    }

    @Nonnull
    public CompletionStage<ProductDraftBuilder> resolveProductTypeReference(@Nonnull ProductDraftBuilder draftBuilder) {
        try {
            return this.resolveResourceIdentifier(draftBuilder, draftBuilder.getProductType(), this.productTypeService::fetchCachedProductTypeId, ResourceIdentifier::ofId, (rec$, x$0) -> (ProductDraftBuilder)((ProductDraftBuilder)rec$).productType(x$0));
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            return io.sphere.sdk.utils.CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, ProductType.referenceTypeId(), draftBuilder.getKey(), referenceResolutionException.getMessage())));
        }
    }

    @Nonnull
    public CompletionStage<ProductDraftBuilder> resolveCategoryReferences(@Nonnull ProductDraftBuilder draftBuilder) {
        Set categoryResourceIdentifiers = draftBuilder.getCategories();
        HashSet<String> categoryKeys = new HashSet<String>();
        for (ResourceIdentifier categoryResourceIdentifier : categoryResourceIdentifiers) {
            if (categoryResourceIdentifier == null) continue;
            try {
                String categoryKey = ProductReferenceResolver.getKeyFromResourceIdentifier(categoryResourceIdentifier);
                categoryKeys.add(categoryKey);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                return io.sphere.sdk.utils.CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, Category.referenceTypeId(), draftBuilder.getKey(), referenceResolutionException.getMessage())));
            }
        }
        return this.fetchAndResolveCategoryReferences(draftBuilder, categoryKeys);
    }

    @Nonnull
    private CompletionStage<ProductDraftBuilder> fetchAndResolveCategoryReferences(@Nonnull ProductDraftBuilder draftBuilder, @Nonnull Set<String> categoryKeys) {
        HashMap categoryOrderHintsMap = new HashMap();
        CategoryOrderHints categoryOrderHints = draftBuilder.getCategoryOrderHints();
        return this.categoryService.fetchMatchingCategoriesByKeys(categoryKeys).thenApply(categories -> categories.stream().map(category -> {
            if (categoryOrderHints != null) {
                Optional.ofNullable(categoryOrderHints.get(category.getKey())).ifPresent(orderHintValue -> categoryOrderHintsMap.put(category.getId(), orderHintValue));
            }
            return category.toReference();
        }).collect(Collectors.toList())).thenApply(categoryReferences -> (ProductDraftBuilder)draftBuilder.categories(categoryReferences).categoryOrderHints(CategoryOrderHints.of((Map)categoryOrderHintsMap)));
    }

    @Nonnull
    public CompletionStage<ProductDraftBuilder> resolveTaxCategoryReference(@Nonnull ProductDraftBuilder draftBuilder) {
        try {
            return this.resolveResourceIdentifier(draftBuilder, draftBuilder.getTaxCategory(), this.taxCategoryService::fetchCachedTaxCategoryId, ResourceIdentifier::ofId, (rec$, x$0) -> (ProductDraftBuilder)((ProductDraftBuilder)rec$).taxCategory(x$0));
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            return io.sphere.sdk.utils.CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, TaxCategory.referenceTypeId(), draftBuilder.getKey(), referenceResolutionException.getMessage())));
        }
    }

    @Nonnull
    public CompletionStage<ProductDraftBuilder> resolveStateReference(@Nonnull ProductDraftBuilder draftBuilder) {
        try {
            return this.resolveResourceIdentifier(draftBuilder, draftBuilder.getState(), this.stateService::fetchCachedStateId, State::referenceOfId, ProductDraftBuilder::state);
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            return io.sphere.sdk.utils.CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, State.referenceTypeId(), draftBuilder.getKey(), referenceResolutionException.getMessage())));
        }
    }

    @Nonnull
    private <T, S extends ResourceIdentifier<T>> CompletionStage<ProductDraftBuilder> resolveResourceIdentifier(@Nonnull ProductDraftBuilder draftBuilder, @Nullable S resourceIdentifier, @Nonnull Function<String, CompletionStage<Optional<String>>> keyToIdMapper, @Nonnull Function<String, S> idToResourceIdentifierMapper, @Nonnull BiFunction<ProductDraftBuilder, S, ProductDraftBuilder> resourceIdentifierSetter) throws ReferenceResolutionException {
        if (resourceIdentifier == null) {
            return CompletableFuture.completedFuture(draftBuilder);
        }
        String resourceKey = ProductReferenceResolver.getKeyFromResourceIdentifier(resourceIdentifier);
        return keyToIdMapper.apply(resourceKey).thenApply(optId -> optId.map(idToResourceIdentifierMapper).map(resourceIdentifierToSet -> (ProductDraftBuilder)resourceIdentifierSetter.apply(draftBuilder, resourceIdentifierToSet)).orElse(draftBuilder));
    }
}

