/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.types.Type;
import io.sphere.sdk.types.TypeDraft;
import io.sphere.sdk.types.commands.TypeCreateCommand;
import io.sphere.sdk.types.commands.TypeUpdateCommand;
import io.sphere.sdk.types.expansion.TypeExpansionModel;
import io.sphere.sdk.types.queries.TypeQuery;
import io.sphere.sdk.types.queries.TypeQueryBuilder;
import io.sphere.sdk.types.queries.TypeQueryModel;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TypeServiceImpl
extends BaseServiceWithKey<TypeDraft, Type, BaseSyncOptions, TypeQuery, TypeQueryModel, TypeExpansionModel<Type>>
implements TypeService {
    public TypeServiceImpl(@Nonnull BaseSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedTypeId(@Nonnull String key) {
        return this.fetchCachedResourceId(key, () -> TypeQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().is(key)).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Set<Type>> fetchMatchingTypesByKeys(@Nonnull Set<String> keys) {
        return this.fetchMatchingResources(keys, () -> TypeQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().isIn((Iterable)keys)).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Type>> fetchType(@Nullable String key) {
        return this.fetchResource(key, () -> TypeQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().is(key)).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Type>> createType(@Nonnull TypeDraft typeDraft) {
        return this.createResource(typeDraft, TypeCreateCommand::of);
    }

    @Override
    @Nonnull
    public CompletionStage<Type> updateType(@Nonnull Type type, @Nonnull List<UpdateAction<Type>> updateActions) {
        return this.updateResource(type, TypeUpdateCommand::of, updateActions);
    }
}

