/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.utils;

import com.commercetools.sync.commons.utils.AssetReferenceReplacementUtils;
import com.commercetools.sync.commons.utils.CustomTypeReferenceReplacementUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.categories.CategoryDraft;
import io.sphere.sdk.categories.CategoryDraftBuilder;
import io.sphere.sdk.categories.expansion.CategoryExpansionModel;
import io.sphere.sdk.categories.queries.CategoryQuery;
import io.sphere.sdk.expansion.ExpansionPath;
import io.sphere.sdk.models.AssetDraft;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.types.CustomFieldsDraft;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class CategoryReferenceReplacementUtils {
    @Nonnull
    public static List<CategoryDraft> replaceCategoriesReferenceIdsWithKeys(@Nonnull List<Category> categories) {
        return categories.stream().map(category -> {
            CustomFieldsDraft customTypeWithKeysInReference = CustomTypeReferenceReplacementUtils.replaceCustomTypeIdWithKeys(category);
            ResourceIdentifier parentWithKeyInReference = SyncUtils.getResourceIdentifierWithKeyReplaced(category.getParent(), () -> ResourceIdentifier.ofId((String)((Category)category.getParent().getObj()).getKey()));
            List<AssetDraft> assetDraftsWithKeyInReference = AssetReferenceReplacementUtils.replaceAssetsReferencesIdsWithKeys(category.getAssets());
            return ((CategoryDraftBuilder)((CategoryDraftBuilder)((CategoryDraftBuilder)CategoryDraftBuilder.of((Category)category).custom(customTypeWithKeysInReference)).parent(parentWithKeyInReference)).assets(assetDraftsWithKeyInReference)).build();
        }).collect(Collectors.toList());
    }

    public static CategoryQuery buildCategoryQuery() {
        return ((CategoryQuery)((CategoryQuery)((CategoryQuery)CategoryQuery.of().withLimit(500L)).withExpansionPaths(ExpansionPath.of((String)"custom.type"))).plusExpansionPaths(ExpansionPath.of((String)"assets[*].custom.type"))).plusExpansionPaths(CategoryExpansionModel::parent);
    }

    private CategoryReferenceReplacementUtils() {
    }
}

