/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import io.sphere.sdk.client.BlockingSphereClient;
import io.sphere.sdk.client.QueueSphereClientDecorator;
import io.sphere.sdk.client.RetrySphereClientDecorator;
import io.sphere.sdk.client.SphereAccessTokenSupplier;
import io.sphere.sdk.client.SphereApiConfig;
import io.sphere.sdk.client.SphereAuthConfig;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.client.SphereClientConfig;
import io.sphere.sdk.http.AsyncHttpClientAdapter;
import io.sphere.sdk.http.HttpClient;
import io.sphere.sdk.retry.RetryAction;
import io.sphere.sdk.retry.RetryPredicate;
import io.sphere.sdk.retry.RetryRule;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;

public final class ClientConfigurationUtils {
    private static HttpClient httpClient;
    private static final long DEFAULT_TIMEOUT = 30000L;
    private static final TimeUnit DEFAULT_TIMEOUT_TIME_UNIT;
    private static Map<SphereClientConfig, SphereClient> delegatesCache;

    public static synchronized SphereClient createClient(@Nonnull SphereClientConfig clientConfig, long timeout, @Nonnull TimeUnit timeUnit) {
        if (!delegatesCache.containsKey(clientConfig)) {
            HttpClient httpClient = ClientConfigurationUtils.getHttpClient();
            SphereAccessTokenSupplier tokenSupplier = SphereAccessTokenSupplier.ofAutoRefresh((SphereAuthConfig)clientConfig, (HttpClient)httpClient, (boolean)false);
            SphereClient underlying = SphereClient.of((SphereApiConfig)clientConfig, (HttpClient)httpClient, (SphereAccessTokenSupplier)tokenSupplier);
            SphereClient retryClient = ClientConfigurationUtils.withRetry(underlying);
            SphereClient limitedParallelRequestsClient = ClientConfigurationUtils.withLimitedParallelRequests(retryClient);
            delegatesCache.put(clientConfig, limitedParallelRequestsClient);
        }
        return BlockingSphereClient.of((SphereClient)delegatesCache.get(clientConfig), (long)timeout, (TimeUnit)timeUnit);
    }

    public static SphereClient createClient(@Nonnull SphereClientConfig clientConfig) {
        return ClientConfigurationUtils.createClient(clientConfig, 30000L, DEFAULT_TIMEOUT_TIME_UNIT);
    }

    private static synchronized HttpClient getHttpClient() {
        if (httpClient == null) {
            DefaultAsyncHttpClient asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)new DefaultAsyncHttpClientConfig.Builder().setHandshakeTimeout(30000).build());
            httpClient = AsyncHttpClientAdapter.of((AsyncHttpClient)asyncHttpClient);
        }
        return httpClient;
    }

    private static SphereClient withRetry(SphereClient delegate) {
        int maxAttempts = 5;
        RetryAction scheduledRetry = RetryAction.ofScheduledRetry((long)5L, context -> ClientConfigurationUtils.calculateVariableDelay(context.getAttempt()));
        RetryPredicate http5xxMatcher = RetryPredicate.ofMatchingStatusCodes((int)502, (int[])new int[]{503, 504});
        List<RetryRule> retryRules = Collections.singletonList(RetryRule.of((Predicate)http5xxMatcher, (Function)scheduledRetry));
        return RetrySphereClientDecorator.of((SphereClient)delegate, retryRules);
    }

    private static Duration calculateVariableDelay(long triedAttempts) {
        long timeoutInSeconds = TimeUnit.SECONDS.convert(30000L, TimeUnit.MILLISECONDS);
        long randomNumberInRange = ClientConfigurationUtils.getRandomNumberInRange(50L, timeoutInSeconds);
        long timeoutMultipliedByTriedAttempts = timeoutInSeconds * triedAttempts;
        return Duration.ofSeconds(timeoutMultipliedByTriedAttempts + randomNumberInRange);
    }

    private static long getRandomNumberInRange(long min, long max) {
        return new Random().longs(min, max + 1L).limit(1L).findFirst().getAsLong();
    }

    private static SphereClient withLimitedParallelRequests(SphereClient delegate) {
        int maxParallelRequests = 20;
        return QueueSphereClientDecorator.of((SphereClient)delegate, (int)20);
    }

    private ClientConfigurationUtils() {
    }

    static {
        DEFAULT_TIMEOUT_TIME_UNIT = TimeUnit.MILLISECONDS;
        delegatesCache = new HashMap<SphereClientConfig, SphereClient>();
    }
}

