/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.models.Resource;
import io.sphere.sdk.queries.PagedQueryResult;
import io.sphere.sdk.queries.QueryDsl;
import io.sphere.sdk.queries.QueryPredicate;
import io.sphere.sdk.queries.QuerySort;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

final class QueryAll<T extends Resource, C extends QueryDsl<T, C>, S> {
    private final SphereClient client;
    private final QueryDsl<T, C> baseQuery;
    private final long pageSize;
    private Function<List<T>, S> pageMapper;
    private final List<S> mappedResultsTillNow;
    private Consumer<List<T>> pageConsumer;

    private QueryAll(@Nonnull SphereClient client, @Nonnull QueryDsl<T, C> baseQuery, long pageSize) {
        this.client = client;
        this.baseQuery = QueryAll.withDefaults(baseQuery, pageSize);
        this.pageSize = pageSize;
        this.mappedResultsTillNow = new ArrayList<S>();
    }

    @Nonnull
    private static <T extends Resource, C extends QueryDsl<T, C>> QueryDsl<T, C> withDefaults(@Nonnull QueryDsl<T, C> query, long pageSize) {
        QueryDsl withLimit = query.withLimit(pageSize);
        return !withLimit.sort().isEmpty() ? withLimit : withLimit.withSort(QuerySort.of((String)"id asc"));
    }

    @Nonnull
    static <T extends Resource, C extends QueryDsl<T, C>, S> QueryAll<T, C, S> of(@Nonnull SphereClient client, @Nonnull QueryDsl<T, C> baseQuery, int pageSize) {
        return new QueryAll<T, C, S>(client, baseQuery, pageSize);
    }

    @Nonnull
    CompletionStage<List<S>> run(@Nonnull Function<List<T>, S> pageMapper) {
        this.pageMapper = pageMapper;
        CompletionStage firstPage = this.client.execute(this.baseQuery);
        return this.queryNextPages(firstPage).thenApply(voidResult -> this.mappedResultsTillNow);
    }

    @Nonnull
    CompletionStage<Void> run(@Nonnull Consumer<List<T>> pageConsumer) {
        this.pageConsumer = pageConsumer;
        CompletionStage firstPage = this.client.execute(this.baseQuery);
        return this.queryNextPages(firstPage).thenAccept(voidResult -> {});
    }

    @Nonnull
    private CompletionStage<Void> queryNextPages(@Nonnull CompletionStage<PagedQueryResult<T>> currentPageStage) {
        return currentPageStage.thenCompose(currentPage -> currentPage != null ? this.queryNextPages(this.processPageAndGetNext((PagedQueryResult<T>)currentPage)) : CompletableFuture.completedFuture(null));
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<PagedQueryResult<T>> processPageAndGetNext(@Nonnull PagedQueryResult<T> page) {
        List currentPageElements = page.getResults();
        if (!currentPageElements.isEmpty()) {
            this.mapOrConsume(currentPageElements);
            return this.getNextPageStage(currentPageElements);
        }
        return CompletableFuture.completedFuture(null);
    }

    private void mapOrConsume(@Nonnull List<T> pageElements) {
        if (this.pageConsumer != null) {
            this.pageConsumer.accept(pageElements);
        } else {
            this.mappedResultsTillNow.add(this.pageMapper.apply(pageElements));
        }
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<PagedQueryResult<T>> getNextPageStage(@Nonnull List<T> pageElements) {
        if ((long)pageElements.size() == this.pageSize) {
            String lastElementId = ((Resource)pageElements.get(pageElements.size() - 1)).getId();
            QueryPredicate queryPredicate = QueryPredicate.of((String)String.format("id > \"%s\"", lastElementId));
            return this.client.execute((SphereRequest)this.baseQuery.plusPredicates(queryPredicate));
        }
        return CompletableFuture.completedFuture(null);
    }
}

