/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.helpers;

import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.inventories.InventorySyncOptions;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.TypeService;
import io.sphere.sdk.channels.Channel;
import io.sphere.sdk.inventory.InventoryEntryDraft;
import io.sphere.sdk.inventory.InventoryEntryDraftBuilder;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.utils.CompletableFutureUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public final class InventoryReferenceResolver
extends CustomReferenceResolver<InventoryEntryDraft, InventoryEntryDraftBuilder, InventorySyncOptions> {
    private static final String CHANNEL_DOES_NOT_EXIST = "Channel with key '%s' does not exist.";
    private static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type resource identifier on InventoryEntryDraft with SKU:'%s'.";
    private static final String FAILED_TO_RESOLVE_SUPPLY_CHANNEL = "Failed to resolve supply channel resource identifier on InventoryEntryDraft with SKU:'%s'. Reason: %s";
    private ChannelService channelService;

    public InventoryReferenceResolver(@Nonnull InventorySyncOptions options, @Nonnull TypeService typeService, @Nonnull ChannelService channelService) {
        super(options, typeService);
        this.channelService = channelService;
    }

    @Override
    public CompletionStage<InventoryEntryDraft> resolveReferences(@Nonnull InventoryEntryDraft draft) {
        return this.resolveCustomTypeReference(InventoryEntryDraftBuilder.of((InventoryEntryDraft)draft)).thenCompose(this::resolveSupplyChannelReference).thenApply(InventoryEntryDraftBuilder::build);
    }

    @Override
    @Nonnull
    protected CompletionStage<InventoryEntryDraftBuilder> resolveCustomTypeReference(@Nonnull InventoryEntryDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, InventoryEntryDraftBuilder::getCustom, InventoryEntryDraftBuilder::custom, String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getSku()));
    }

    @Nonnull
    CompletionStage<InventoryEntryDraftBuilder> resolveSupplyChannelReference(@Nonnull InventoryEntryDraftBuilder draftBuilder) {
        ResourceIdentifier channelReference = draftBuilder.getSupplyChannel();
        if (channelReference != null) {
            try {
                String channelKey = InventoryReferenceResolver.getKeyFromResourceIdentifier(channelReference);
                return this.fetchOrCreateAndResolveReference(draftBuilder, channelKey);
            }
            catch (ReferenceResolutionException exception) {
                return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_SUPPLY_CHANNEL, draftBuilder.getSku(), exception.getMessage()), exception));
            }
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    private CompletionStage<InventoryEntryDraftBuilder> fetchOrCreateAndResolveReference(@Nonnull InventoryEntryDraftBuilder draftBuilder, @Nonnull String channelKey) {
        CompletionStage inventoryEntryDraftCompletionStage = this.channelService.fetchCachedChannelId(channelKey).thenCompose(resolvedChannelIdOptional -> resolvedChannelIdOptional.map(resolvedChannelId -> InventoryReferenceResolver.setChannelReference(resolvedChannelId, draftBuilder)).orElseGet(() -> this.createChannelAndSetReference(channelKey, draftBuilder)));
        CompletableFuture<InventoryEntryDraftBuilder> result = new CompletableFuture<InventoryEntryDraftBuilder>();
        inventoryEntryDraftCompletionStage.whenComplete((resolvedDraftBuilder, exception) -> {
            if (exception != null) {
                result.completeExceptionally(new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_SUPPLY_CHANNEL, draftBuilder.getSku(), exception.getCause().getMessage()), (Throwable)exception));
            } else {
                result.complete((InventoryEntryDraftBuilder)resolvedDraftBuilder);
            }
        });
        return result;
    }

    @Nonnull
    private static CompletionStage<InventoryEntryDraftBuilder> setChannelReference(@Nonnull String channelId, @Nonnull InventoryEntryDraftBuilder draftBuilder) {
        return CompletableFuture.completedFuture(draftBuilder.supplyChannel(ResourceIdentifier.ofId((String)channelId)));
    }

    @Nonnull
    private CompletionStage<InventoryEntryDraftBuilder> createChannelAndSetReference(@Nonnull String channelKey, @Nonnull InventoryEntryDraftBuilder draftBuilder) {
        if (((InventorySyncOptions)this.options).shouldEnsureChannels()) {
            return this.channelService.createAndCacheChannel(channelKey).thenCompose(createdChannelOptional -> {
                if (createdChannelOptional.isPresent()) {
                    return InventoryReferenceResolver.setChannelReference(((Channel)createdChannelOptional.get()).getId(), draftBuilder);
                }
                ReferenceResolutionException referenceResolutionException = new ReferenceResolutionException(String.format(CHANNEL_DOES_NOT_EXIST, channelKey));
                return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)referenceResolutionException);
            });
        }
        ReferenceResolutionException referenceResolutionException = new ReferenceResolutionException(String.format(CHANNEL_DOES_NOT_EXIST, channelKey));
        return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)referenceResolutionException);
    }
}

