/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.helpers;

import com.commercetools.sync.commons.helpers.BaseSyncStatistics;
import io.sphere.sdk.utils.SphereInternalUtils;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProductSyncStatistics
extends BaseSyncStatistics {
    private ConcurrentHashMap<String, Set<String>> productKeysWithMissingParents = new ConcurrentHashMap();

    @Override
    public String getReportMessage() {
        this.reportMessage = String.format("Summary: %s product(s) were processed in total (%s created, %s updated, %s failed to sync and %s product(s) with missing reference(s)).", this.getProcessed(), this.getCreated(), this.getUpdated(), this.getFailed(), this.getNumberOfProductsWithMissingParents());
        return this.reportMessage;
    }

    public int getNumberOfProductsWithMissingParents() {
        return (int)this.productKeysWithMissingParents.values().stream().flatMap(Collection::stream).distinct().count();
    }

    public void addMissingDependency(@Nonnull String parentKey, @Nonnull String childKey) {
        this.productKeysWithMissingParents.merge(parentKey, SphereInternalUtils.asSet((Object[])new String[]{childKey}), (existingSet, newChildAsSet) -> {
            existingSet.addAll(newChildAsSet);
            return existingSet;
        });
    }

    @Nullable
    public Set<String> removeAndGetReferencingKeys(@Nonnull String key) {
        return this.productKeysWithMissingParents.remove(key);
    }
}

