/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.sync.commons.helpers.CategoryReferencePair;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.products.utils.VariantReferenceReplacementUtils;
import io.sphere.sdk.categories.Category;
import io.sphere.sdk.expansion.ExpansionPath;
import io.sphere.sdk.models.LocalizedString;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.models.Referenceable;
import io.sphere.sdk.models.ResourceIdentifiable;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.products.CategoryOrderHints;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.ProductData;
import io.sphere.sdk.products.ProductDraft;
import io.sphere.sdk.products.ProductDraftBuilder;
import io.sphere.sdk.products.ProductDraftDsl;
import io.sphere.sdk.products.ProductVariant;
import io.sphere.sdk.products.ProductVariantDraft;
import io.sphere.sdk.products.ProductVariantDraftBuilder;
import io.sphere.sdk.products.ProductVariantDraftDsl;
import io.sphere.sdk.products.expansion.ProductExpansionModel;
import io.sphere.sdk.products.queries.ProductQuery;
import io.sphere.sdk.producttypes.ProductType;
import io.sphere.sdk.states.State;
import io.sphere.sdk.taxcategories.TaxCategory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProductReferenceReplacementUtils {
    @Nonnull
    public static List<ProductDraft> replaceProductsReferenceIdsWithKeys(@Nonnull List<Product> products) {
        return products.stream().filter(Objects::nonNull).map(product -> {
            ProductDraftDsl productDraft = ProductReferenceReplacementUtils.getDraftBuilderFromStagedProduct(product).build();
            ResourceIdentifier<ProductType> productTypeReferenceWithKey = ProductReferenceReplacementUtils.replaceProductTypeReferenceIdWithKey(product);
            ResourceIdentifier<TaxCategory> taxCategoryReferenceWithKey = ProductReferenceReplacementUtils.replaceTaxCategoryReferenceIdWithKey(product);
            Reference<State> stateReferenceWithKey = ProductReferenceReplacementUtils.replaceProductStateReferenceIdWithKey(product);
            CategoryReferencePair categoryReferencePair = ProductReferenceReplacementUtils.replaceCategoryReferencesIdsWithKeys(product);
            Set<ResourceIdentifier<Category>> categoryResourceIdentifiers = categoryReferencePair.getCategoryResourceIdentifiers();
            CategoryOrderHints categoryOrderHintsWithKeys = categoryReferencePair.getCategoryOrderHints();
            List allVariants = product.getMasterData().getStaged().getAllVariants();
            List<ProductVariantDraft> variantDraftsWithKeys = VariantReferenceReplacementUtils.replaceVariantsReferenceIdsWithKeys(allVariants);
            ProductVariantDraft masterVariantDraftWithKeys = variantDraftsWithKeys.remove(0);
            return ((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)ProductDraftBuilder.of((ProductDraft)productDraft).masterVariant(masterVariantDraftWithKeys)).variants(variantDraftsWithKeys).productType(productTypeReferenceWithKey)).categories(categoryResourceIdentifiers)).categoryOrderHints(categoryOrderHintsWithKeys)).taxCategory(taxCategoryReferenceWithKey)).state(stateReferenceWithKey).build();
        }).collect(Collectors.toList());
    }

    @Nonnull
    public static ProductDraftBuilder getDraftBuilderFromStagedProduct(@Nonnull Product product) {
        ProductData productData = product.getMasterData().getStaged();
        List allVariants = productData.getAllVariants().stream().map(productVariant -> ProductVariantDraftBuilder.of((ProductVariant)productVariant).build()).collect(Collectors.toList());
        ProductVariantDraftDsl masterVariant = ProductVariantDraftBuilder.of((ProductVariant)product.getMasterData().getStaged().getMasterVariant()).build();
        return (ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)((ProductDraftBuilder)ProductDraftBuilder.of((ResourceIdentifiable)product.getProductType(), (LocalizedString)productData.getName(), (LocalizedString)productData.getSlug(), allVariants).masterVariant((ProductVariantDraft)masterVariant)).metaDescription(productData.getMetaDescription())).metaKeywords(productData.getMetaKeywords())).metaTitle(productData.getMetaTitle())).description(productData.getDescription())).searchKeywords(productData.getSearchKeywords())).taxCategory(product.getTaxCategory()).state((Referenceable)product.getState()).key(product.getKey())).publish(product.getMasterData().isPublished())).categories(new ArrayList(productData.getCategories())).categoryOrderHints(productData.getCategoryOrderHints());
    }

    @Nullable
    static ResourceIdentifier<ProductType> replaceProductTypeReferenceIdWithKey(@Nonnull Product product) {
        Reference productType = product.getProductType();
        return SyncUtils.getResourceIdentifierWithKeyReplaced(productType, () -> ResourceIdentifier.ofId((String)((ProductType)productType.getObj()).getKey()));
    }

    @Nullable
    static ResourceIdentifier<TaxCategory> replaceTaxCategoryReferenceIdWithKey(@Nonnull Product product) {
        Reference productTaxCategory = product.getTaxCategory();
        return SyncUtils.getResourceIdentifierWithKeyReplaced(productTaxCategory, () -> ResourceIdentifier.ofId((String)((TaxCategory)productTaxCategory.getObj()).getKey()));
    }

    @Nullable
    static Reference<State> replaceProductStateReferenceIdWithKey(@Nonnull Product product) {
        Reference productState = product.getState();
        return SyncUtils.getReferenceWithKeyReplaced(productState, () -> State.referenceOfId((String)((State)productState.getObj()).getKey()));
    }

    @Nonnull
    static CategoryReferencePair replaceCategoryReferencesIdsWithKeys(@Nonnull Product product) {
        Set categoryReferences = product.getMasterData().getStaged().getCategories();
        HashSet<ResourceIdentifier<Category>> categoryResourceIdentifiers = new HashSet<ResourceIdentifier<Category>>();
        CategoryOrderHints categoryOrderHints = product.getMasterData().getStaged().getCategoryOrderHints();
        HashMap categoryOrderHintsMapWithKeys = new HashMap();
        categoryReferences.forEach(categoryReference -> categoryResourceIdentifiers.add(SyncUtils.getResourceIdentifierWithKeyReplaced(categoryReference, () -> {
            String categoryOrderHintValue;
            String categoryId = categoryReference.getId();
            String categoryKey = ((Category)categoryReference.getObj()).getKey();
            if (categoryOrderHints != null && (categoryOrderHintValue = categoryOrderHints.get(categoryId)) != null) {
                categoryOrderHintsMapWithKeys.put(categoryKey, categoryOrderHintValue);
            }
            return ResourceIdentifier.ofId((String)categoryKey);
        })));
        CategoryOrderHints categoryOrderHintsWithKeys = categoryOrderHintsMapWithKeys.isEmpty() ? categoryOrderHints : CategoryOrderHints.of(categoryOrderHintsMapWithKeys);
        return CategoryReferencePair.of(categoryResourceIdentifiers, categoryOrderHintsWithKeys);
    }

    @Nonnull
    public static ProductQuery buildProductQuery() {
        return (ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)((ProductQuery)ProductQuery.of().withLimit(500L)).withExpansionPaths(ProductExpansionModel::productType)).plusExpansionPaths(ProductExpansionModel::taxCategory)).plusExpansionPaths(ExpansionPath.of((String)"state"))).plusExpansionPaths(expansionModel -> expansionModel.masterData().staged().categories())).plusExpansionPaths(expansionModel -> expansionModel.masterData().staged().allVariants().prices().channel())).plusExpansionPaths(ExpansionPath.of((String)"masterData.staged.masterVariant.prices[*].custom.type"))).plusExpansionPaths(ExpansionPath.of((String)"masterData.staged.variants[*].prices[*].custom.type"))).plusExpansionPaths(expansionModel -> expansionModel.masterData().staged().allVariants().attributes().value())).plusExpansionPaths(expansionModel -> expansionModel.masterData().staged().allVariants().attributes().valueSet())).plusExpansionPaths(ExpansionPath.of((String)"masterData.staged.masterVariant.assets[*].custom.type"))).plusExpansionPaths(ExpansionPath.of((String)"masterData.staged.variants[*].assets[*].custom.type"));
    }

    private ProductReferenceReplacementUtils() {
    }
}

