/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.PriceCustomActionBuilder;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.products.Price;
import io.sphere.sdk.products.PriceDraft;
import io.sphere.sdk.products.Product;
import io.sphere.sdk.products.commands.updateactions.ChangePrice;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.money.MonetaryAmount;

public final class ProductVariantPriceUpdateActionUtils {
    private static final String VARIANT_CHANGE_PRICE_EMPTY_VALUE = "Cannot unset 'value' field of price with id '%s'.";

    @Nonnull
    public static List<UpdateAction<Product>> buildActions(@Nonnull Integer variantId, @Nonnull Price oldPrice, @Nonnull PriceDraft newPrice, @Nonnull ProductSyncOptions syncOptions) {
        ArrayList<UpdateAction<Product>> updateActions = new ArrayList<UpdateAction<Product>>();
        ProductVariantPriceUpdateActionUtils.buildChangePriceUpdateAction(oldPrice, newPrice, syncOptions).ifPresent(updateActions::add);
        updateActions.addAll(ProductVariantPriceUpdateActionUtils.buildCustomUpdateActions(variantId, oldPrice, newPrice, syncOptions));
        return updateActions;
    }

    @Nonnull
    public static Optional<ChangePrice> buildChangePriceUpdateAction(@Nonnull Price oldPrice, @Nonnull PriceDraft newPrice, @Nonnull ProductSyncOptions syncOptions) {
        MonetaryAmount oldPriceValue = oldPrice.getValue();
        MonetaryAmount newPriceValue = newPrice.getValue();
        if (newPriceValue == null) {
            syncOptions.applyWarningCallback(String.format(VARIANT_CHANGE_PRICE_EMPTY_VALUE, oldPrice.getId()));
            return Optional.empty();
        }
        Optional<ChangePrice> actionAfterValuesDiff = CommonTypeUpdateActionUtils.buildUpdateAction(oldPriceValue, newPriceValue, () -> ChangePrice.of((Price)oldPrice, (PriceDraft)newPrice, (Boolean)true));
        return actionAfterValuesDiff.map(Optional::of).orElseGet(() -> CommonTypeUpdateActionUtils.buildUpdateAction(oldPrice.getTiers(), newPrice.getTiers(), () -> ChangePrice.of((Price)oldPrice, (PriceDraft)newPrice, (Boolean)true)));
    }

    @Nonnull
    public static List<UpdateAction<Product>> buildCustomUpdateActions(@Nonnull Integer variantId, @Nonnull Price oldPrice, @Nonnull PriceDraft newPrice, @Nonnull ProductSyncOptions syncOptions) {
        return CustomUpdateActionUtils.buildCustomUpdateActions(oldPrice, newPrice, new PriceCustomActionBuilder(), variantId, Price::getId, price -> Price.resourceTypeId(), Price::getId, syncOptions);
    }

    private ProductVariantPriceUpdateActionUtils() {
    }
}

